package com.biz.crm.member.business.member.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.Label;
import com.biz.crm.member.business.member.local.entity.SystemSettings;
import com.biz.crm.member.business.member.local.entity.SystemSettingsDetail;
import com.biz.crm.member.business.member.local.repository.SystemSettingsDetailRepository;
import com.biz.crm.member.business.member.local.repository.SystemSettingsRepository;
import com.biz.crm.member.business.member.local.service.SystemSettingsService;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsDetailVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsReservedVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 系统设置表服务层
 *
 * @author hupan
 * @date 2023/6/21 11:04
 */
@Slf4j
@Service("systemSettingsServiceImpl")
public class SystemSettingsServiceImpl implements SystemSettingsService {

  @Autowired
  private SystemSettingsRepository systemSettingsRepository;
  @Autowired
  private SystemSettingsDetailRepository systemSettingsDetailRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private GenerateCodeService generateCodeService;

  @Override
  public List<SystemSettingsVo> findAll() {
    //将标题字段的属性全部初始化
    List<SystemSettings> listTitleInit = systemSettingsRepository.list();
    List<String> listType = listTitleInit.stream().map(SystemSettings::getType).collect(Collectors.toList());
    //将所有的缺少的标题字段都设置进数据库
    attributePaddingTitle(listType);
    //此时拿到的list,每一种标题类型都是包括的
    List<SystemSettings> list = systemSettingsRepository.list();
    List<SystemSettingsVo> resultList = new ArrayList<>();
    //根据每一个类型,填充detail的值
    for (SystemSettings systemSettings : list) {
      String type = systemSettings.getType();
      SystemSettingsVo systemSettingsVo = nebulaToolkitService
          .copyObjectByWhiteList(systemSettings, SystemSettingsVo.class, HashSet.class,
              LinkedList.class);
      List<SystemSettingsDetail> listDetail = systemSettingsDetailRepository.lambdaQuery()
          .eq(SystemSettingsDetail::getType, type).list();
      List<SystemSettingsDetailVo> resultDetailList = new ArrayList<>();
      for (SystemSettingsDetail systemSettingsDetail : listDetail) {
        SystemSettingsDetailVo systemSettingsDetailVo = nebulaToolkitService
            .copyObjectByWhiteList(systemSettingsDetail, SystemSettingsDetailVo.class, HashSet.class,
                LinkedList.class);
        //对连续x年等级会员以上做特殊处理
        if (!systemSettingsDetailVo.getTypeKey().equals(SystemSettingsDetailEnum.CONTINUOUS_X_LEVEL_MEMBER.getValue())) {
          resultDetailList.add(systemSettingsDetailVo);
        }
      }
      systemSettingsVo.setDetails(resultDetailList);
      resultList.add(systemSettingsVo);
    }
    return resultList;
  }

  @Override
  public List<SystemSettingsReservedVo> findReserved() {
    List<SystemSettingsReservedVo> reservedVos = new ArrayList<>();
    List<SystemSettingsDetail> list = systemSettingsDetailRepository.lambdaQuery()
        .eq(SystemSettingsDetail::getType,
            SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue())
        .list();
    for (SystemSettingsDetail systemSettingsDetail : list) {
      SystemSettingsReservedVo systemSettingsReservedVo = this.nebulaToolkitService
          .copyObjectByWhiteList(systemSettingsDetail, SystemSettingsReservedVo.class,
              HashSet.class, LinkedList.class);
      reservedVos.add(systemSettingsReservedVo);
    }
    return reservedVos;
  }

  private void attributePaddingTitle(List<String> list) {
    if (!list.contains(SystemSettingsTypeEnum.VALIDITY_PERIOD_OF_POINTS_SETTING.getValue())){
      //积分有效期设置
      doAttributePaddingTitle(SystemSettingsTypeEnum.VALIDITY_PERIOD_OF_POINTS_SETTING.getValue());
      doAttributePaddingField(SystemSettingsTypeEnum.VALIDITY_PERIOD_OF_POINTS_SETTING.getValue(),
          SystemSettingsDetailEnum.VALIDITY_PERIOD_OF_POINTS.getValue(),"12","");
    }
    if (!list.contains(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue())){
      //权益分类设置
      doAttributePaddingTitle(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue());
      doAttributePaddingFieldReserved(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue(),
          SystemSettingsDetailEnum.CONTINUOUS_X_LEVEL_MEMBER.getValue(),"A");
      doAttributePaddingFieldReserved(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue(),
          SystemSettingsDetailEnum.BIRTHDAY_BENEFITS.getValue(),"B");
      doAttributePaddingFieldReserved(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue(),
          SystemSettingsDetailEnum.TASTING_SEND_WINE.getValue(),"C");
      doAttributePaddingFieldReserved(SystemSettingsTypeEnum.BENEFITS_CLASSIFICATION_SETTING.getValue(),
          SystemSettingsDetailEnum.ECOLOGICAL_TOUR.getValue(),"D");
    }
    if (!list.contains(SystemSettingsTypeEnum.APPRECIATION_ADVISOR_CARD.getValue())){
      //品鉴顾问卡片
      doAttributePaddingTitle(SystemSettingsTypeEnum.APPRECIATION_ADVISOR_CARD.getValue());
      doAttributePaddingField(SystemSettingsTypeEnum.APPRECIATION_ADVISOR_CARD.getValue(),
          SystemSettingsDetailEnum.CARD_IMAGE.getValue(),"","");
    }
    if (!list.contains(SystemSettingsTypeEnum.MEMBERSHIP_FISSION.getValue())){
      //会员裂变
      doAttributePaddingTitle(SystemSettingsTypeEnum.MEMBERSHIP_FISSION.getValue());
      doAttributePaddingField(SystemSettingsTypeEnum.MEMBERSHIP_FISSION.getValue(),
          SystemSettingsDetailEnum.MEMBERSHIP_CARD.getValue(),"开启","");
      doAttributePaddingField(SystemSettingsTypeEnum.MEMBERSHIP_FISSION.getValue(),
          SystemSettingsDetailEnum.INVITATION_POINTS_RATIO.getValue(),"10%","");
    }
    if (!list.contains(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue())){
      //团购设置
      doAttributePaddingTitle(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue());
      doAttributePaddingField(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue(),
          SystemSettingsDetailEnum.MEMBERSHIP_THRESHOLD.getValue(),"300","");
      doAttributePaddingField(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue(),
          SystemSettingsDetailEnum.SIGNING_RECORD_STATISTICS_TIME.getValue(),"2023年10月1日 13:00:00","");
      doAttributePaddingField(SystemSettingsTypeEnum.GROUP_BUYING_CONFIG.getValue(),
          SystemSettingsDetailEnum.FLAG_NEED_APPROVAL.getValue(),"","");
    }
    if (!list.contains(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue())){
      //文旅答题配置
      doAttributePaddingTitle(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue());
      doAttributePaddingField(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue(),
          SystemSettingsDetailEnum.ANSWERING_CORRECTLY_POINTS.getValue(),"1","");
      doAttributePaddingField(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue(),
          SystemSettingsDetailEnum.MAX_POINTS_PER_MONTH.getValue(),"10","");
      doAttributePaddingField(SystemSettingsTypeEnum.CULTURAL_AND_TOURISM_ANSWER_CONFIG.getValue(),
          SystemSettingsDetailEnum.ACTIVITY_RULES.getValue(),"","");
    }
    if (!list.contains(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue())) {
      //客服配置
      doAttributePaddingTitle(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue());
      doAttributePaddingField(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue(),
          SystemSettingsDetailEnum.ONLINE_CUSTOMER_SERVICE_SETTINGS.getValue(),"关闭","");
      doAttributePaddingField(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue(),
          SystemSettingsDetailEnum.TELEPHONE_CUSTOMER_SERVICE_SETTINGS.getValue(),"关闭","");
      doAttributePaddingField(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue(),
          SystemSettingsDetailEnum.CUSTOMER_SERVICE_TELEPHONE.getValue(),"1234567890","");
    }
    if (!list.contains(SystemSettingsTypeEnum.UPGRADE_RULES.getValue())){
      //升级规则
      doAttributePaddingTitle(SystemSettingsTypeEnum.UPGRADE_RULES.getValue());
      doAttributePaddingField(SystemSettingsTypeEnum.UPGRADE_RULES.getValue(),
          SystemSettingsDetailEnum.UPGRADE_RULE_DESC.getValue(),"","");
    }
    if (!list.contains(SystemSettingsTypeEnum.BUSINESS_CARD_PAGE_COMPANY_INTRODUCTION.getValue())){
      //名片页面公司介绍
      doAttributePaddingTitle(SystemSettingsTypeEnum.BUSINESS_CARD_PAGE_COMPANY_INTRODUCTION.getValue());
      doAttributePaddingField(SystemSettingsTypeEnum.BUSINESS_CARD_PAGE_COMPANY_INTRODUCTION.getValue(),
          SystemSettingsDetailEnum.CARD_PAGE_COMPANY_PROFILE.getValue(),"","");
    }
  }

  private void doAttributePaddingTitle(String type) {
    SystemSettings systemSettings = new SystemSettings();
    //设置租户编号,生成标签编码和默认值
    systemSettings.setId(null);
    systemSettings.setType(type);
    systemSettings.setTenantCode(TenantUtils.getTenantCode());
    systemSettings.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    systemSettings.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    systemSettingsRepository.saveOrUpdate(systemSettings);
  }

  private void doAttributePaddingField(String type,String typeKey,String typeValue,String typeValueText) {
    SystemSettingsDetail systemSettingsDetail = new SystemSettingsDetail();
    //设置租户编号,生成标签编码和默认值
    systemSettingsDetail.setId(null);
    systemSettingsDetail.setType(type);
    systemSettingsDetail.setTypeKey(typeKey);
    systemSettingsDetail.setTypeValue(typeValue);
    systemSettingsDetail.setTypeValueText(typeValueText);
    systemSettingsDetail.setTenantCode(TenantUtils.getTenantCode());
    systemSettingsDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    systemSettingsDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    systemSettingsDetailRepository.saveOrUpdate(systemSettingsDetail);
  }

  private void doAttributePaddingFieldReserved(String type,String typeKey,String reservedOne) {
    SystemSettingsDetail systemSettingsDetail = new SystemSettingsDetail();
    //设置租户编号,生成标签编码和默认值
    systemSettingsDetail.setId(null);
    systemSettingsDetail.setReservedFieldsOne(reservedOne);
    systemSettingsDetail.setType(type);
    systemSettingsDetail.setTypeKey(typeKey);
    systemSettingsDetail.setTenantCode(TenantUtils.getTenantCode());
    systemSettingsDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    systemSettingsDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    systemSettingsDetailRepository.saveOrUpdate(systemSettingsDetail);
  }

  private void createValidation(SystemSettingsVo systemSettingsVo) {
    this.validation(systemSettingsVo);
  }

  private void updateValidation(SystemSettingsVo systemSettingsVo) {
    this.validation(systemSettingsVo);
  }

  private void validation(SystemSettingsVo systemSettingsVo) {
    Validate.notBlank(systemSettingsVo.getType(), "系统类型不能为空");
    for (SystemSettingsDetailVo detail : systemSettingsVo.getDetails()) {
      Validate.notBlank(detail.getType(),"系统详细类型不能为空");
      Validate.notBlank(detail.getTypeKey(),"系统详细类型key不能为空");
    }
  }
}
