package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.TaskingAdvisorInviteRecord;
import com.biz.crm.member.business.member.local.repository.TaskingAdvisorInviteRecordRepository;
import com.biz.crm.member.business.member.local.service.TaskingAdvisorInviteRecordService;
import com.biz.crm.member.business.member.sdk.dto.TaskingAdvisorInviteRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.biz.crm.member.business.member.sdk.vo.TaskingAdvisorInviteRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author hupan
 * @date 2023/6/29 13:41
 */
@Slf4j
@Service("taskingAdvisorInviteRecordServiceImpl")
public class TaskingAdvisorInviteRecordServiceImpl implements TaskingAdvisorInviteRecordService {

  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private TaskingAdvisorInviteRecordRepository taskingAdvisorInviteRecordRepository;

  @Override
  public Page<TaskingAdvisorInviteRecordVo> findByConditions(Pageable pageable,
      TaskingAdvisorInviteRecordPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new TaskingAdvisorInviteRecordPaginationDto());
    Page<TaskingAdvisorInviteRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.taskingAdvisorInviteRecordRepository.findByConditions(page, dto);
  }

  @Override
  public TaskingAdvisorInviteRecordVo create(
      TaskingAdvisorInviteRecordVo taskingAdvisorInviteRecordVo) {
    this.validation(taskingAdvisorInviteRecordVo);
    TaskingAdvisorInviteRecord taskingAdvisorInviteRecord = this.nebulaToolkitService.copyObjectByWhiteList(taskingAdvisorInviteRecordVo,TaskingAdvisorInviteRecord.class,
        HashSet.class, LinkedList.class);
    taskingAdvisorInviteRecord.setTenantCode(TenantUtils.getTenantCode());
    taskingAdvisorInviteRecord.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    taskingAdvisorInviteRecord.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    this.taskingAdvisorInviteRecordRepository.saveOrUpdate(taskingAdvisorInviteRecord);
    return taskingAdvisorInviteRecordVo;
  }

  private void validation(TaskingAdvisorInviteRecordVo taskingAdvisorInviteRecordVo) {
    Validate.notBlank(taskingAdvisorInviteRecordVo.getMemberCode(), "会员编码不能为空");
    Validate.notBlank(taskingAdvisorInviteRecordVo.getMemberName(), "会员名称不能为空");
    Validate.notBlank(taskingAdvisorInviteRecordVo.getMemberPhone(),"会员手机号不能为空");
    Validate.notNull(taskingAdvisorInviteRecordVo.getMemberRegister(),"注册时间不能为空");
    Validate.notBlank(taskingAdvisorInviteRecordVo.getTastingCode(),"品鉴顾问编码不能为空");
    Validate.notBlank(taskingAdvisorInviteRecordVo.getTastingName(),"品鉴顾问名称不能为空");
    Validate.notBlank(taskingAdvisorInviteRecordVo.getTastingPhone(),"品鉴顾问手机号不能为空");
    Validate.notBlank(taskingAdvisorInviteRecordVo.getLinkOrgCode(),"关联组织编码不能为空");
    Validate.notBlank(taskingAdvisorInviteRecordVo.getLinkOrgName(),"关联组织不能为空");
    Validate.notNull(taskingAdvisorInviteRecordVo.getCurrentGrow(),"会员成长值不能为空");
    Validate.notNull(taskingAdvisorInviteRecordVo.getAccumulateGrow(),"会员累计成长值不能为空");
  }
}
