package com.biz.crm.member.business.member.local.service.internal;

import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.local.service.MemberInfoLevelChangeRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.local.service.TouristAPIService;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoLevelChangeRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.TouristAPIVo;
import java.util.Optional;
import liquibase.pro.packaged.A;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author hupan
 * @date 2023/6/28 14:43
 */
@Slf4j
@Service
public class TouristAPIServiceImpl implements TouristAPIService {

  @Autowired
  private UserSearchHelper userSearchHelper;
  @Autowired
  private MemberInfoService memberInfoService;
  @Autowired
  private SystemSettingsDetailService systemSettingsDetailService;
  @Autowired
  private MemberInfoLevelChangeRecordService memberInfoLevelChangeRecordService;
  @Autowired
  private LevelManageService levelManageService;

  @Override
  public TouristAPIVo cardInfo() {
    //用于返回的实体
    TouristAPIVo resultVo = new TouristAPIVo();
    String memberCode = userSearchHelper.getMemberLogin().getMemberCode();
    MemberInfoVo memberInfoVo = memberInfoService.findDetailByMemberCode(memberCode);
    memberInfoVo = Optional.ofNullable(memberInfoVo).orElse(new MemberInfoVo());
    //如果邀请人编码为空,则不显示卡片信息
    if (memberInfoVo.getInviteMemberCode() == null){
      return null;
    }
    //查询邀请人的信息
    MemberInfoVo memberInfoVoInvite = memberInfoService.findDetailByMemberCode(memberInfoVo.getInviteMemberCode());
    //如果邀请人不是品鉴顾问,则返回会员卡片和名字
    if (memberInfoVoInvite.getLinkTastingName() == null){
      //先通过会员编码获取memberInfoLevelChangeRecord里面的等级编码
      MemberInfoLevelChangeRecordVo detailByMemberCode = memberInfoLevelChangeRecordService
          .findDetailByMemberCode(memberCode);
      //然后通过等级编码获取levelManage表的详细,包含了卡片url
      LevelManageVo detailByLevelCode = levelManageService
          .findDetailByLevelCode(detailByMemberCode.getLevelCode());
      resultVo.setInviterName(memberInfoVoInvite.getMemberName());
      resultVo.setCardUrl(detailByLevelCode.getCardImageOne());
      return resultVo;
    }
    //否则返回品鉴顾问卡片和名字
    String typeValue = systemSettingsDetailService
        .findValueByKey(SystemSettingsDetailEnum.CARD_IMAGE.getValue()).getTypeValue();
    resultVo.setInviterName(memberInfoVoInvite.getLinkTastingName());
    resultVo.setCardUrl(typeValue);
    return resultVo;
  }
}
