package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.ViewpagerEntity;
import com.biz.crm.member.business.member.local.entity.ViewpagerFile;
import com.biz.crm.member.business.member.local.repository.*;
import com.biz.crm.member.business.member.local.service.ViewpagerService;
import com.biz.crm.member.business.member.sdk.dto.ViewpagerDto;
import com.biz.crm.member.business.member.sdk.dto.ViewpagerFileDto;
import com.biz.crm.member.business.member.sdk.enums.SkipTypeEnum;
import com.biz.crm.member.business.member.sdk.enums.UseAreaEnum;
import com.biz.crm.member.business.member.sdk.vo.ViewpagerFileVo;
import com.biz.crm.member.business.member.sdk.vo.ViewpagerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 轮播图实现类
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 10:18
 **/
@Service
public class ViewpagerServiceImpl implements ViewpagerService {

    @Autowired
    private ViewpagerRepository viewpagerRepository;
    @Autowired
    private ViewpagerFileRepository viewpagerFileRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;

    /**
     * 轮播图编码redis key
     * 参数：租户
     */
    public static final String MMS_VIEWPAGER_CODE_REDIS_KEY = "mms:viewpager:code:index:%s";

    /**
     * 轮播图编码前缀
     */
    public static final String MMS_VIEWPAGER_CODE_PREFIX = "LB";

    /**
     * 生成编码
     */
    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_VIEWPAGER_CODE_REDIS_KEY, tenantCode);
        String index = redisMutexService.getAndIncrement(redisKey, 1, 6);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join(MMS_VIEWPAGER_CODE_PREFIX, format.format(new Date()), index);
    }

    @Override
    public Page<ViewpagerVo> findByConditions(Pageable pageable, ViewpagerDto viewpagerDto) {
        if (Objects.isNull(viewpagerDto)) {
            viewpagerDto = new ViewpagerDto();
        }
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
        Page<ViewpagerVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.viewpagerRepository.findByConditions(page, viewpagerDto);
    }

    @Override
    public ViewpagerVo findDetailById(String id) {
        if(StringUtils.isBlank(id)) {
            return null;
        }
        //主信息
        ViewpagerEntity viewpagerEntity = this.viewpagerRepository.getById(id);
        ViewpagerVo viewpagerVo = this.nebulaToolkitService.copyObjectByWhiteList(viewpagerEntity, ViewpagerVo.class, HashSet.class, LinkedList.class);

        //图片
//        List<ViewpagerFile> files = this.viewpagerFileRepository.lambdaQuery().eq(ViewpagerFile::getViewpagerCode, viewpagerVo.getCode()).eq(ViewpagerFile::getDelFlag,DelFlagStatusEnum.NORMAL.getCode()).list();
//        if(!CollectionUtils.isEmpty(files)) {
//            List<ViewpagerFileVo> fileVos = (List<ViewpagerFileVo>) this.nebulaToolkitService.copyCollectionByWhiteList(files, ViewpagerFile.class, ViewpagerFileVo.class, HashSet.class, LinkedList.class);
//            viewpagerVo.setFiles(fileVos);
//        }
        return viewpagerVo;
    }

    @Transactional
    @Override
    public ViewpagerVo create(ViewpagerDto viewpagerDto) {
        this.createValidate(viewpagerDto);
        String code = this.generateCode(TenantUtils.getTenantCode());
        viewpagerDto.setCode(code);
        ViewpagerEntity viewpagerEntity = this.nebulaToolkitService.copyObjectByWhiteList(viewpagerDto, ViewpagerEntity.class, HashSet.class, LinkedList.class);
        viewpagerEntity.setTenantCode(TenantUtils.getTenantCode());
        viewpagerEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        viewpagerEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.viewpagerRepository.saveOrUpdate(viewpagerEntity);

//        List<ViewpagerFileDto> files = viewpagerDto.getFiles();
//        if(!CollectionUtils.isEmpty(files)) {
//            files.stream().forEach(e ->{
//                e.setViewpagerCode(viewpagerEntity.getCode());
//                e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
//                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
//                e.setTenantCode(TenantUtils.getTenantCode());
//            });
//
//            List<ViewpagerFile> viewpagerFiles = (List<ViewpagerFile>) this.nebulaToolkitService.copyCollectionByWhiteList(files, ViewpagerFileDto.class, ViewpagerFile.class, HashSet.class, LinkedList.class);
//            this.viewpagerFileRepository.saveBatch(viewpagerFiles);
//
//        }
        return this.nebulaToolkitService.copyObjectByWhiteList(viewpagerEntity,ViewpagerVo.class,HashSet.class,LinkedList.class);
    }

    /**
     * 校验
     * @param viewpagerDto
     */
    private void createValidate(ViewpagerDto viewpagerDto) {

        Validate.notNull(viewpagerDto,"新增实体参数不能为空");
        Validate.notNull(viewpagerDto.getSortIndex(),"序号不能为空");
        Validate.notNull(viewpagerDto.getStartDate(),"开始时间不能为空");
        Validate.notNull(viewpagerDto.getEndDate(),"结束时间不能为空");
        Validate.notBlank(viewpagerDto.getUseArea(),"应用区域不能为空");
        Validate.notBlank(viewpagerDto.getSkipType(),"跳转类型不能为空");
        Validate.notBlank(viewpagerDto.getMainFileCode(),"图片不能为空");
        if(!SkipTypeEnum.NO.getCode().equals(viewpagerDto.getSkipType())) {
            Validate.notBlank(viewpagerDto.getSkipUrl(),"跳转路径不能为空");
        }

//        List<ViewpagerFileDto> files = viewpagerDto.getFiles();
//        if(!CollectionUtils.isEmpty(files)) {
//            for (ViewpagerFileDto file : files) {
//                Validate.notBlank(file.getFileId(),"文件id不能为空");
//                Validate.notBlank(file.getFileName(),"文件名称不能为空");
//                Validate.notBlank(file.getType(),"文件id不能为空");
//                Validate.notNull(file.getMainImage(),"是否主图不能为空");
//            }
//        }

    }


    @Transactional
    @Override
    public ViewpagerVo update(ViewpagerDto viewpagerDto) {
        this.updateValidate(viewpagerDto);
        ViewpagerEntity oldViewpager = this.viewpagerRepository.getById(viewpagerDto.getId());
        Validate.notNull(oldViewpager,"编辑对象不存在");
        //TODO:赋值编辑人信息

        ViewpagerEntity viewpagerEntity = this.nebulaToolkitService.copyObjectByWhiteList(viewpagerDto, ViewpagerEntity.class, HashSet.class, LinkedList.class);
        this.viewpagerRepository.saveOrUpdate(viewpagerEntity);

//        QueryWrapper<ViewpagerFile> wrapper = new QueryWrapper<>();
//        wrapper.eq("viewpager_code",viewpagerDto.getCode());
//        wrapper.eq("tenant_code",viewpagerDto.getTenantCode());
//        this.viewpagerFileRepository.remove(wrapper);

//        List<ViewpagerFileDto> files = viewpagerDto.getFiles();
//        if(!CollectionUtils.isEmpty(files)) {
//            files.stream().forEach(e ->{
//                e.setId(null);
//                e.setViewpagerCode(viewpagerEntity.getCode());
//                e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
//                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
//                e.setTenantCode(TenantUtils.getTenantCode());
//            });
//            List<ViewpagerFile> viewpagerFiles = (List<ViewpagerFile>) this.nebulaToolkitService.copyCollectionByWhiteList(files, ViewpagerFileDto.class, ViewpagerFile.class, HashSet.class, LinkedList.class);
//            this.viewpagerFileRepository.saveBatch(viewpagerFiles);
//        }
        return this.nebulaToolkitService.copyObjectByWhiteList(viewpagerEntity, ViewpagerVo.class, HashSet.class, LinkedList.class);
    }

    private void updateValidate(ViewpagerDto viewpagerDto) {

        Validate.notNull(viewpagerDto,"编辑实体参数不能为空");
        Validate.notNull(viewpagerDto.getSortIndex(),"序号不能为空");
        Validate.notNull(viewpagerDto.getStartDate(),"开始时间不能为空");
        Validate.notNull(viewpagerDto.getEndDate(),"结束时间不能为空");
        Validate.notBlank(viewpagerDto.getUseArea(),"应用区域不能为空");
        Validate.notBlank(viewpagerDto.getSkipType(),"跳转类型不能为空");
        Validate.notBlank(viewpagerDto.getMainFileCode(),"图片不能为空");

        Validate.notBlank(viewpagerDto.getCode(),"编辑时，编码不能为空！");
        Validate.notBlank(viewpagerDto.getId(),"编辑时，主键id不能为空");

        if(!SkipTypeEnum.NO.getCode().equals(viewpagerDto.getSkipType())) {
            Validate.notBlank(viewpagerDto.getSkipUrl(),"跳转路径不能为空");
        }

//        List<ViewpagerFileDto> files = viewpagerDto.getFiles();
//        if(!CollectionUtils.isEmpty(files)) {
//            for (ViewpagerFileDto file : files) {
//                Validate.notBlank(file.getFileId(),"文件id不能为空");
//                Validate.notBlank(file.getFileName(),"文件名称不能为空");
//                Validate.notBlank(file.getType(),"文件id不能为空");
//                Validate.notNull(file.getMainImage(),"是否主图不能为空");
//            }
//        }
    }

    @Override
    public void enableBatch(List<String> ids) {

        if(CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.viewpagerRepository.lambdaUpdate().set(ViewpagerEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .in(ViewpagerEntity::getId,ids).update();

    }

    @Override
    public void disableBatch(List<String> ids) {

        if(CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.viewpagerRepository.lambdaUpdate().set(ViewpagerEntity::getEnableStatus, EnableStatusEnum.DISABLE.getCode())
                .in(ViewpagerEntity::getId,ids).update();

    }

    @Override
    public void deleteBatch(List<String> ids) {

        if(CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.viewpagerRepository.lambdaUpdate().set(ViewpagerEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .in(ViewpagerEntity::getId,ids).update();

    }

    /**
     * 根据应用区域获取一个当前时间正在启用的轮播图信息
     * @Author 吴平
     */
    @Override
    public List<ViewpagerVo> getEnableOneByUseArea(String useAreaCode) {
        Validate.notBlank(useAreaCode, "应用区域不能为空");
        Date currentTime = new Date(System.currentTimeMillis());
        /**
         * 开始时间小于等于当前时间，且结束时间大于等于当前时间的轮播图，限制条数为一条
         * */
        LambdaQueryWrapper<ViewpagerEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.le(ViewpagerEntity::getStartDate, currentTime)
            .ge(ViewpagerEntity::getEndDate, currentTime)
            .eq(ViewpagerEntity::getUseArea, useAreaCode)
            .eq(ViewpagerEntity::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
            .eq(ViewpagerEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        List<ViewpagerEntity> bannerList = this.viewpagerRepository.list(queryWrapper);
        Collection<ViewpagerVo> result = this.nebulaToolkitService
            .copyCollectionByWhiteList(bannerList, ViewpagerEntity.class, ViewpagerVo.class,
                HashSet.class, LinkedList.class);
        return (List<ViewpagerVo>) result;
    }
}
