package com.biz.crm.member.business.member.local.utils;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/**
 * @ClassName AssertUtils
 * @Author huanglong
 * @Date 2019/2/21 11:28
 * @Description 断言工具类，判断是否满足断言,如果不满足,则抛出CRM异常
 */
public class AssertUtils {

    /**
     * 如果不是true，则抛异常
     * @param expression
     * @param msg
     */
    public static void isTrue(boolean expression, String msg) {
        if (!expression) {
            throw new RuntimeException(msg);
        }
    }
    /**
     * 如果是fasle，则抛异常
     * @param expression
     * @param msg
     */
    public static void isFalse(boolean expression, String msg) {
        if (expression) {
            throw new RuntimeException(msg);
        }
    }

    /**
     * 如果是空或者空字符串，则抛异常
     * @param str
     * @param msg
     */
    public static void isNotEmpty(String str, String msg) {
        if (StringUtils.isEmpty(str)) {
            throw new RuntimeException(msg);
        }
    }

    /**
     * 如果数组为空或者长度小于1，则抛异常
     * @param str
     * @param msg
     */
    public static void isNotEmpty(Object[] str, String msg) {
        if (ObjectUtils.isEmpty(str)) {
            throw new RuntimeException(msg);
        }
    }

    /**
     * 如果集合为空或者长度小于1，则抛异常
     * @param collection
     * @param msg
     */
    public static void isNotEmpty(Collection<?> collection, String msg) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new RuntimeException(msg);
        }
    }

    /**
     * 如果集合为空或者长度小于1，则抛异常
     * @param map
     * @param msg
     */
    public static void isNotEmpty(Map<?, ?> map, String msg) {
        if (CollectionUtils.isEmpty(map)) {
            throw new RuntimeException(msg);
        }
    }

    /**
     * 如果对象时空，则抛异常
     * @param object
     * @param msg
     */
    public static void isNotNull(Object object, String msg) {
        if (object == null) {
            throw new RuntimeException(msg);
        }
    }
}
