/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ActivityApplyRecordService;
import com.biz.crm.member.business.member.sdk.dto.ActivityApplyRecordDto;
import com.biz.crm.member.business.member.sdk.vo.ActivityApplyRecordVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u62a5\u540d\u8bb0\u5f55"})
@RestController
@RequestMapping(value={"/v1/member/activity/apply/record"})
public class ActivityApplyRecordController {
    private static final Logger log = LoggerFactory.getLogger(ActivityApplyRecordController.class);
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ActivityApplyRecordService activityApplyRecordService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ActivityApplyRecordVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, ActivityApplyRecordDto pageDto) {
        try {
            Page<ActivityApplyRecordVo> result = this.activityApplyRecordService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<ActivityApplyRecordVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            ActivityApplyRecordVo viewpagerVo = this.activityApplyRecordService.findDetailById(id);
            return Result.ok((Object)viewpagerVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<ActivityApplyRecordVo> create(@RequestBody ActivityApplyRecordDto activityApplyRecordDto) {
        try {
            ActivityApplyRecordVo current = this.activityApplyRecordService.create(activityApplyRecordDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u6d3b\u52a8\u4f01\u5212(\u91cd\u65b0)\u62a5\u540d")
    @PostMapping(value={"join"})
    public Result<?> join(@RequestBody ActivityApplyRecordDto dto) {
        boolean locked = false;
        try {
            Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getOperateId()), (String)"\u62a5\u540d\u64cd\u4f5cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            locked = this.redisMutexService.tryLock(dto.getOperateId(), TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)locked, (String)"\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb\uff01", (Object[])new Object[0]);
            this.activityApplyRecordService.join(dto);
            Result result = Result.ok((String)"OK");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(dto.getOperateId());
            }
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u62a5\u540d\u64cd\u4f5c\u6807\u8bc6(\u9632\u91cd\u590d\u70b9\u51fb)")
    @PostMapping(value={"/getId"})
    public Result<String> getId() {
        Result result = new Result();
        result.setResult((Object)this.activityApplyRecordService.getId());
        return result;
    }

    @ApiOperation(value="(\u5c0f\u7a0b\u5e8f\u6d3b\u52a8\u4f01\u5212\u7b7e\u5230)")
    @GetMapping(value={"sign"})
    public Result<?> sign(ActivityApplyRecordDto activityApplyRecordDto) {
        try {
            this.activityApplyRecordService.sign(activityApplyRecordDto);
            return Result.ok((String)"OK");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<ActivityApplyRecordVo> update(@RequestBody ActivityApplyRecordDto activityApplyRecordDto) {
        try {
            ActivityApplyRecordVo current = this.activityApplyRecordService.updateForm(activityApplyRecordDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PatchMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u5ba1\u6279")
    @PatchMapping(value={"/approvalPass"})
    public Result approvalPass(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.approvalPass(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u5ba1\u6279")
    @PatchMapping(value={"/approvalReturn"})
    public Result approvalReturn(@RequestBody List<String> ids) {
        try {
            this.activityApplyRecordService.approvalReturn(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

