/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ActivityManageService;
import com.biz.crm.member.business.member.sdk.dto.ActivityManageDto;
import com.biz.crm.member.business.member.sdk.dto.ActivityManagePageDto;
import com.biz.crm.member.business.member.sdk.vo.ActivityManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.ActivityManageVo;
import com.bizunited.nebula.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d3b\u52a8\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/member/activity"})
public class ActivityManageController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ActivityManageController.class);
    @Autowired
    private ActivityManageService activityManageService;

    @ApiOperation(value="\u540e\u53f0\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ActivityManagePageVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, ActivityManagePageDto pageDto) {
        try {
            Page<ActivityManagePageVo> result = this.activityManageService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditionsByApplet"})
    public Result<Page<ActivityManagePageVo>> findByConditionsByApplet(@PageableDefault(value=50) Pageable pageable, ActivityManagePageDto pageDto) {
        try {
            Page<ActivityManagePageVo> result = this.activityManageService.findByConditionsByApplet(pageable, pageDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<ActivityManageVo> findDetailById(@RequestParam(value="id") String id, @RequestParam(value="fromPhone", required=false) String fromPhone) {
        try {
            ActivityManageVo viewpagerVo = this.activityManageService.findDetailById(id, fromPhone);
            return Result.ok((Object)viewpagerVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<ActivityManageVo> create(@RequestBody ActivityManageDto activityManageDto) {
        try {
            ActivityManageVo current = this.activityManageService.create(activityManageDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<ActivityManageVo> update(@RequestBody ActivityManageDto activityManageDto) {
        try {
            ActivityManageVo current = this.activityManageService.updateForm(activityManageDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.activityManageService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.activityManageService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PatchMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.activityManageService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u751f\u6210\u4e8c\u7ef4\u7801")
    @GetMapping(value={"/buildBarCode"})
    public Result buildBarCode(@RequestParam(value="code") String code) {
        try {
            this.activityManageService.buildBarCode(code);
            return Result.ok((String)"\u751f\u6210\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

