/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ChoiceNessCategoryService;
import com.biz.crm.member.business.member.sdk.dto.ChoiceNessCategoryDto;
import com.biz.crm.member.business.member.sdk.dto.ChoiceNessCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.ChoiceNessCategoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cbe\u9009\u5206\u7c7b\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/choice/ness/category"})
public class ChoiceNessCategoryController {
    private static final Logger log = LoggerFactory.getLogger(ChoiceNessCategoryController.class);
    @Autowired
    private ChoiceNessCategoryService choiceNessCategoryService;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping
    public Result<ChoiceNessCategoryVo> createChoiceNessCategory(@RequestBody ChoiceNessCategoryDto dto) {
        try {
            ChoiceNessCategoryVo result = this.choiceNessCategoryService.createChoiceNessCategory(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping
    public Result<ChoiceNessCategoryVo> update(@RequestBody ChoiceNessCategoryDto dto) {
        try {
            ChoiceNessCategoryVo result = this.choiceNessCategoryService.updateChoiceNessCategory(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u5355\u4e2a\u7cbe\u9009\u5206\u7c7b")
    @GetMapping(value={"/{id}"})
    public Result<ChoiceNessCategoryVo> getChoiceNessCategory(@PathVariable(value="id") String id) {
        try {
            ChoiceNessCategoryVo result = this.choiceNessCategoryService.getChoiceNessCategoryById(id);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u7cbe\u9009\u5206\u7c7b\u4fe1\u606f")
    @GetMapping(value={"/page"})
    public Result<Page<ChoiceNessCategoryVo>> pageCategory(@PageableDefault(value=50) Pageable pageable, ChoiceNessCategoryPaginationDto dto) {
        try {
            Page<ChoiceNessCategoryVo> result = this.choiceNessCategoryService.pageChoiceNessCategory(pageable, dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/turn/on"})
    public Result turnOnCategory(@RequestBody List<String> ids) {
        try {
            this.choiceNessCategoryService.turnOnCategory(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/turn/off"})
    public Result turnOffCategory(@RequestBody List<String> ids) {
        try {
            this.choiceNessCategoryService.turnOffCategory(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping
    public Result logicDeleteCategory(@RequestParam(value="ids") List<String> ids) {
        try {
            this.choiceNessCategoryService.logicDeleteCategory(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

