/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.DiscussService;
import com.biz.crm.member.business.member.sdk.dto.DiscussDto;
import com.biz.crm.member.business.member.sdk.dto.DiscussPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.DiscussVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bc4\u8bba\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/discuss/manage"})
public class DiscussController {
    private static final Logger log = LoggerFactory.getLogger(DiscussController.class);
    private final Integer CHOICE_DISCUSS = 1;
    private final Integer NO_CHOICE_DISCUSS = 0;
    @Autowired
    private DiscussService discussService;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping
    public Result<DiscussVo> createDiscuss(@RequestBody DiscussDto dto) {
        try {
            DiscussVo result = this.discussService.createDiscuss(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping
    public Result logicDeleteByIds(@RequestParam(value="ids") List<String> ids) {
        try {
            this.discussService.logicDeleteByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u64cd\u4f5c\u5ba1\u6838\u72b6\u6001==>\u901a\u8fc7||\u9a73\u56de||\u53cd\u5ba1\u6279")
    @PatchMapping(value={"/batch/check/status"})
    public Result batchApprove(@RequestBody List<String> ids, String checkStatus) {
        try {
            this.discussService.batchModifyCheckStatus(ids, checkStatus);
            return Result.ok((String)"\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/turn/on"})
    public Result turnOnDiscuss(@RequestBody List<String> ids) {
        try {
            this.discussService.turnOnDiscuss(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/turn/off"})
    public Result turnOffDiscuss(@RequestBody List<String> ids) {
        try {
            this.discussService.turnOffDiscuss(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7cbe\u9009")
    @PatchMapping(value={"/choice/discuss"})
    public Result batchModifyChoiceDiscuss(@RequestBody List<String> ids) {
        try {
            this.discussService.batchModifyChoiceDiscuss(ids, this.CHOICE_DISCUSS);
            return Result.ok((String)"\u7cbe\u9009\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u7cbe\u9009")
    @PatchMapping(value={"/cancel/choice/discuss"})
    public Result batchCancelChoiceDiscuss(@RequestBody List<String> ids) {
        try {
            this.discussService.batchModifyChoiceDiscuss(ids, this.NO_CHOICE_DISCUSS);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u8bc4\u8bba")
    @GetMapping(value={"/page"})
    public Result<Page<DiscussVo>> pageResult(@PageableDefault(value=50) Pageable pageable, DiscussPaginationDto dto) {
        try {
            Page<DiscussVo> result = this.discussService.pageDiscuss(pageable, dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

