/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.InfoCategoryService;
import com.biz.crm.member.business.member.sdk.dto.InfoCategoryDto;
import com.biz.crm.member.business.member.sdk.dto.InfoCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.InfoCategoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u8baf\u5206\u7c7b\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/infoCategory/manage"})
public class InfoCategoryController {
    private static final Logger log = LoggerFactory.getLogger(InfoCategoryController.class);
    @Autowired
    private InfoCategoryService infoCategoryService;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping
    public Result<InfoCategoryVo> create(@RequestBody InfoCategoryDto infoCategoryDto) {
        try {
            InfoCategoryVo result = this.infoCategoryService.createInfoCategory(infoCategoryDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PatchMapping
    public Result<InfoCategoryVo> updateInfoCategory(@RequestBody InfoCategoryDto infoCategoryDto) {
        try {
            InfoCategoryVo result = this.infoCategoryService.updateInfoCategory(infoCategoryDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u8d44\u8baf\u7ba1\u7406\u4fe1\u606f")
    @GetMapping(value={"/page"})
    public Result<Page<InfoCategoryVo>> pageInfoCategory(@PageableDefault(value=50) Pageable pageable, InfoCategoryPaginationDto paginationDto) {
        try {
            Page<InfoCategoryVo> result = this.infoCategoryService.pageInfoCategory(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u8d44\u8baf\u5206\u7c7b\u4fe1\u606f")
    @GetMapping(value={"/{infoCategoryId}"})
    public Result<InfoCategoryVo> getInfoCategoryById(@PathVariable(value="infoCategoryId") String id) {
        try {
            InfoCategoryVo result = this.infoCategoryService.getInfoCategoryById(id);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/turn/on"})
    public Result turnOnInfoCategory(@RequestBody List<String> ids) {
        try {
            this.infoCategoryService.turnOnInfoCategory(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/turn/off"})
    public Result turnOffInfoCategory(@RequestBody List<String> ids) {
        try {
            this.infoCategoryService.turnOffInfoCategory(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping
    public Result logicDeleteInfoCategory(@RequestParam(value="ids") List<String> ids) {
        try {
            this.infoCategoryService.logicDeleteInfoCategory(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

