/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.InfoManageService;
import com.biz.crm.member.business.member.local.service.InfoUpvoteService;
import com.biz.crm.member.business.member.sdk.dto.InfoManageDto;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.InfoManagePubDto;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u8baf\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/info/manage"})
public class InfoManageController {
    private static final Logger log = LoggerFactory.getLogger(InfoManageController.class);
    @Autowired
    private InfoManageService infoManageService;
    @Autowired
    private InfoUpvoteService infoUpvoteService;

    @ApiOperation(value="\u65b0\u589e\u5bcc\u6587\u672c\u8d44\u8baf")
    @PostMapping(value={"/rich/text"})
    public Result<InfoManageVo> createRichText(@RequestBody InfoManageDto dto) {
        try {
            InfoManageVo result = this.infoManageService.createRichText(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/pub/account"})
    @ApiOperation(value="\u65b0\u589e\u516c\u4f17\u53f7\u8d44\u8baf")
    public Result<InfoManageVo> createPubAccount(@RequestBody InfoManagePubDto dto) {
        try {
            InfoManageVo result = this.infoManageService.createPubAccount(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result logicDeleteInfoByIds(@RequestParam(value="ids") List<String> ids) {
        try {
            this.infoManageService.logicDeleteInfoByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u8d44\u8baf")
    @PutMapping(value={"/modify"})
    public Result<InfoManageVo> modifyInfo(@RequestBody InfoManageDto dto) {
        try {
            InfoManageVo result = this.infoManageService.updateInfo(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/turn/on"})
    public Result turnOnInfo(@RequestBody List<String> ids) {
        try {
            this.infoManageService.turnOnInfoByIds(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/turn/off"})
    public Result turnOffInfo(@RequestBody List<String> ids) {
        try {
            this.infoManageService.turnOffByIds(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u8d44\u8baf\u4fe1\u606f")
    @GetMapping(value={"/page"})
    public Result<Page<InfoManageVo>> pageResult(@PageableDefault(value=50) Pageable pageable, InfoManagePaginationDto dto) {
        try {
            Page<InfoManageVo> result = this.infoManageService.pageInfo(pageable, dto);
            return Result.ok(result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa \u5f85\u5b9a")
    @GetMapping(value={"/export"})
    public Result exportByIds(List<String> ids) {
        return null;
    }
}

