/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.LabelCategoryService;
import com.biz.crm.member.business.member.sdk.vo.LabelCategoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6807\u7b7e\u5206\u7c7b\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/label/labelCategpryManage"})
public class LabelCategoryController {
    private static final Logger log = LoggerFactory.getLogger(LabelCategoryController.class);
    @Resource
    LabelCategoryService categoryService;

    @ApiOperation(value="\u67e5\u8be2\u6807\u7b7e\u5206\u7c7b\u7684\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<LabelCategoryVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, LabelCategoryVo vo) {
        try {
            Page<LabelCategoryVo> result = this.categoryService.findByConditions(pageable, vo);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f1a\u5458\u7f16\u8f91\u6807\u7b7e - \u67e5\u8be2\u6240\u6709\u6807\u7b7e\u5206\u7c7b")
    @GetMapping(value={"/labelCategpryAll"})
    public Result<List<LabelCategoryVo>> labelCategoryAll() {
        try {
            List<LabelCategoryVo> result = this.categoryService.labelCategoryAll();
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f1a\u5458\u7f16\u8f91\u6807\u7b7e - \u67e5\u8be2\u6240\u6709\u6807\u7b7e")
    @GetMapping(value={"/labelAll"})
    public Result<List<LabelCategoryVo>> labelAll(LabelCategoryVo vo) {
        try {
            List<LabelCategoryVo> result = this.categoryService.labelAll(vo);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={""})
    public Result create(@RequestBody LabelCategoryVo labelCategoryVo) {
        try {
            this.categoryService.create(labelCategoryVo);
            return Result.ok((String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PatchMapping(value={""})
    public Result update(@RequestBody LabelCategoryVo labelCategoryVo) {
        try {
            this.categoryService.update(labelCategoryVo);
            return Result.ok((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.categoryService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.categoryService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.categoryService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6807\u7b7e\u6392\u5e8f\u4e0a\u79fb")
    @GetMapping(value={"/up"})
    public Result up(@RequestParam(value="id") String id) {
        try {
            this.categoryService.updateSort(id, -1);
            return Result.ok((String)"\u4e0a\u79fb\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6807\u7b7e\u6392\u5e8f\u4e0b\u79fb")
    @GetMapping(value={"/down"})
    public Result down(@RequestParam(value="id") String id) {
        try {
            this.categoryService.updateSort(id, 1);
            return Result.ok((String)"\u4e0b\u79fb\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    public Result<List<LabelCategoryVo>> findComboBox() {
        try {
            List<LabelCategoryVo> result = this.categoryService.findByConditions();
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

