/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.LabelService;
import com.biz.crm.member.business.member.sdk.dto.LabelPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.LabelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6807\u7b7e\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/label/labelManage"})
public class LabelController {
    private static final Logger log = LoggerFactory.getLogger(LabelController.class);
    @Resource
    private LabelService labelService;

    @ApiOperation(value="\u67e5\u8be2\u6807\u7b7e\u5206\u9875")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<LabelVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, LabelPaginationDto labelPaginationDto) {
        try {
            Page<LabelVo> lists = this.labelService.findByConditions(pageable, labelPaginationDto);
            return Result.ok(lists);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={""})
    public Result create(@RequestBody LabelVo labelVo) {
        try {
            this.labelService.create(labelVo);
            return Result.ok((String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PatchMapping(value={""})
    public Result update(@RequestBody LabelVo labelVo) {
        try {
            this.labelService.update(labelVo);
            return Result.ok((String)"\u7f16\u8f91\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b")
    @GetMapping(value={"/findDetailById"})
    public Result findDetailById(@RequestParam(value="id") String id) {
        try {
            LabelVo labelVo = this.labelService.findDetailById(id);
            return Result.ok((Object)labelVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u542f\u7528\u6807\u7b7e")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.labelService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u7981\u7528\u6807\u7b7e")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.labelService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.labelService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

