/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.sdk.dto.LevelManagePaginationDto;
import com.biz.crm.member.business.member.sdk.vo.LevelManageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7b49\u7ea7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/levelManage/levelManage"})
public class LevelManageController {
    private static final Logger log = LoggerFactory.getLogger(LevelManageController.class);
    @Autowired(required=false)
    private LevelManageService levelManageService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<LevelManageVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, LevelManagePaginationDto paginationDto) {
        try {
            Page<LevelManageVo> result = this.levelManageService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6240\u6709\u7b49\u7ea7")
    @GetMapping(value={"/allList"})
    public Result<List<LevelManageVo>> allList() {
        try {
            List<LevelManageVo> result = this.levelManageService.allList();
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<LevelManageVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            LevelManageVo levelManageVo = this.levelManageService.findDetailById(id);
            return Result.ok((Object)levelManageVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<LevelManageVo> create(@RequestBody LevelManageVo levelManageVo) {
        try {
            LevelManageVo current = this.levelManageService.create(levelManageVo);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<LevelManageVo> update(@RequestBody LevelManageVo levelManageVo) {
        try {
            LevelManageVo current = this.levelManageService.update(levelManageVo);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.levelManageService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.levelManageService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.levelManageService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

