/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAllVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoAssetsVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoGrowRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f1a\u5458\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/memberInfo/memberInfo"})
public class MemberInfoController {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoController.class);
    @Autowired(required=false)
    private MemberInfoService memberInfoService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<MemberInfoVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, MemberInfoPaginationDto paginationDto) {
        try {
            Page<MemberInfoVo> result = this.memberInfoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7")
    @PostMapping(value={"approvalPass"})
    public Result approvalPass(@RequestBody MemberInfoVo memberInfoVo) {
        try {
            this.memberInfoService.approvalPass(memberInfoVo);
            return Result.ok((String)"\u5ba1\u6279\u901a\u8fc7");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u9a73\u56de")
    @PostMapping(value={"approvalReject"})
    public Result approvalReject(@RequestBody MemberInfoVo memberInfoVo) {
        try {
            this.memberInfoService.approvalReject(memberInfoVo);
            return Result.ok((String)"\u5ba1\u6279\u9a73\u56de");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ef4\u62a4\u884c\u4e1a")
    @PostMapping(value={"maintainIndustry"})
    public Result maintainIndustry(@RequestBody MemberInfoVo memberInfoVo) {
        try {
            this.memberInfoService.maintainIndustry(memberInfoVo);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ef4\u62a4\u90e8\u95e8")
    @PostMapping(value={"maintainDepartment"})
    public Result maintainDepartment(@RequestBody MemberInfoVo memberInfoVo) {
        try {
            this.memberInfoService.maintainDepartment(memberInfoVo);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u57fa\u7840\u8d44\u6599")
    @GetMapping(value={"/findAllDetailById"})
    public Result<MemberInfoAllVo> findAllDetailById(@RequestParam(value="id") String id) {
        try {
            MemberInfoAllVo memberInfoAllVo = this.memberInfoService.findAllDetailById(id);
            return Result.ok((Object)memberInfoAllVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f1a\u5458\u8d44\u4ea7")
    @GetMapping(value={"/findAssetsDetailById"})
    public Result<MemberInfoAssetsVo> findAssetsDetailById(@RequestParam(value="id") String id) {
        try {
            MemberInfoAssetsVo memberInfoAssetsVo = this.memberInfoService.findAssetsDetailById(id);
            return Result.ok((Object)memberInfoAssetsVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u79ef\u5206")
    @PostMapping(value={"updateIntegral"})
    public Result updateIntegral(@RequestBody MemberInfoIntegralRecordVo memberInfoIntegralRecordVo) {
        try {
            this.memberInfoService.updateIntegral(memberInfoIntegralRecordVo);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6210\u957f\u503c")
    @PostMapping(value={"updateGrow"})
    public Result updateGrow(@RequestBody MemberInfoGrowRecordVo memberInfoGrowRecordVo) {
        try {
            this.memberInfoService.updateGrow(memberInfoGrowRecordVo);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<MemberInfoVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            MemberInfoVo memberInfoVo = this.memberInfoService.findDetailById(id);
            return Result.ok((Object)memberInfoVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<MemberInfoVo> create(@RequestBody MemberInfoVo memberInfoVo) {
        try {
            MemberInfoVo current = this.memberInfoService.create(memberInfoVo);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<MemberInfoVo> update(@RequestBody MemberInfoVo memberInfoVo) {
        try {
            MemberInfoVo current = this.memberInfoService.update(memberInfoVo);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.memberInfoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.memberInfoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.memberInfoService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

