/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.MessageManageService;
import com.biz.crm.member.business.member.sdk.dto.MessageManageDto;
import com.biz.crm.member.business.member.sdk.dto.MessageManagePageDto;
import com.biz.crm.member.business.member.sdk.vo.MessageManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.MessageManageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d88\u606f/\u5f39\u7a97\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/member/message"})
public class MessageManageController {
    private static final Logger log = LoggerFactory.getLogger(MessageManageController.class);
    @Autowired
    private MessageManageService messageManageService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<MessageManagePageVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, MessageManagePageDto pageDto) {
        try {
            Page<MessageManagePageVo> result = this.messageManageService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<MessageManageVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            MessageManageVo messageManageVo = this.messageManageService.findDetailById(id);
            return Result.ok((Object)messageManageVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<MessageManageVo> create(@RequestBody MessageManageDto messageManageDto) {
        try {
            MessageManageVo current = this.messageManageService.create(messageManageDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<MessageManageVo> update(@RequestBody MessageManageDto messageManageDto) {
        try {
            MessageManageVo current = this.messageManageService.update(messageManageDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.messageManageService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.messageManageService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PatchMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.messageManageService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

