/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.QuestionnaireService;
import com.biz.crm.member.business.member.sdk.dto.AnswerRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionDto;
import com.biz.crm.member.business.member.sdk.dto.QuestionnairePaginationDto;
import com.biz.crm.member.business.member.sdk.enums.QuestionnaireStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.AnswerRecordVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionAnswerVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireAnalyzeVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireDetailVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u95ee\u5377\u7ba1\u7406"})
@RequestMapping(value={"/v1/questionnaire/manage"})
@RestController
public class QuestionnaireController {
    private static final Logger log = LoggerFactory.getLogger(QuestionnaireController.class);
    @Autowired
    private QuestionnaireService questionnaireService;

    @ApiOperation(value="\u65b0\u589e(\u6682\u4e0d\u53d1\u5e03)")
    @PostMapping(value={"/create/questionnaire"})
    public Result<QuestionnaireVo> createQuestionnaire(@RequestBody QuestionDto dto) {
        try {
            QuestionnaireVo result = this.questionnaireService.createQuestionnaire(dto, QuestionnaireStatusEnum.NO_PUBLISH);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e(\u53d1\u5e03)")
    @PostMapping(value={"/create/questionnaire/publish"})
    public Result<QuestionnaireVo> createQuestionnairePublish(@RequestBody QuestionDto dto) {
        try {
            QuestionnaireVo result = this.questionnaireService.createQuestionnairePublish(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u95ee\u5377")
    @GetMapping(value={"/page"})
    public Result<Page<QuestionnaireVo>> pageResult(@PageableDefault(value=50) Pageable pageable, QuestionnairePaginationDto dto) {
        try {
            Page<QuestionnaireVo> result = this.questionnaireService.pageResult(pageable, dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result logicDeleteQuestionnaire(@RequestParam(value="ids") List<String> ids) {
        try {
            this.questionnaireService.logicDelete(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/turn/on"})
    public Result turnOnQuestionnaire(@RequestBody List<String> ids) {
        try {
            this.questionnaireService.turnOnQuestionnaire(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/turn/off"})
    public Result turnOffQuestionnaire(@RequestBody List<String> ids) {
        try {
            this.questionnaireService.turnOffQuestionnaire(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d1\u5e03\u95ee\u5377")
    @GetMapping(value={"/publish"})
    public Result publishQuestionnaire(@RequestParam(value="questionnaireCode") String questionnaireCode) {
        try {
            this.questionnaireService.publishQuestionnaire(questionnaireCode);
            return Result.ok((String)"\u53d1\u5e03\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ed3\u675f\u95ee\u5377")
    @GetMapping(value={"/finish"})
    public Result finishQuestionnaire(@RequestParam(value="questionnaireCode") String questionnaireCode) {
        try {
            this.questionnaireService.finishQuestionnaire(questionnaireCode);
            return Result.ok((String)"\u7ed3\u675f\u95ee\u5377\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u95ee\u5377\u8be6\u60c5", notes="\u6839\u636e\u95ee\u5377\u7f16\u7801\u83b7\u53d6\u95ee\u5377\u8be6\u60c5\uff0c\u8be6\u60c5\u5305\u62ec\u95ee\u5377\u57fa\u672c\u4fe1\u606f\u548c\u95ee\u5377\u9898\u76ee\u914d\u7f6e\u4fe1\u606f\u7b49")
    @GetMapping(value={"/questionnaire/detail/{code}"})
    public Result<QuestionnaireDetailVo> getQuestionnaireDetail(@PathVariable(value="code") String questionnaireCode) {
        try {
            QuestionnaireDetailVo result = this.questionnaireService.getQuestionnaireDetailByCode(questionnaireCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u95ee\u5377")
    @PostMapping(value={"/modify/questionnarie"})
    public Result<QuestionnaireVo> modifyQuestionnaire(@RequestBody QuestionDto dto) {
        try {
            QuestionnaireVo result = this.questionnaireService.modifyQuestionnaire(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u590d\u5236")
    @GetMapping(value={"/questionnaire/copy/{code}"})
    public Result<QuestionnaireVo> copyQuestionnaireByCode(@PathVariable(value="code") String questionnaireCode) {
        try {
            QuestionnaireVo result = this.questionnaireService.copyQuestionnaireByCode(questionnaireCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u95ee\u5377\u5206\u6790")
    @GetMapping(value={"/questionnaire/analyze"})
    public Result<List<QuestionnaireAnalyzeVo>> getQuestionnaireAnalyze(@RequestParam(value="questionnaireCode") String questionnaireCode) {
        try {
            List<QuestionnaireAnalyzeVo> result = this.questionnaireService.getQuestionnaireAnalyze(questionnaireCode);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u770b\u9898\u76ee\u8be6\u60c5")
    @GetMapping(value={"/page/question/detail"})
    public Result<Page<AnswerRecordVo>> pageQuestionDetail(@PageableDefault(value=50) Pageable pageable, AnswerRecordPaginationDto dto) {
        try {
            Page<AnswerRecordVo> result = this.questionnaireService.pageQuestionDetail(pageable, dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u7b54\u5377")
    @GetMapping(value={"/view/question/answer"})
    public Result<List<QuestionAnswerVo>> getQuestionAnswer(@RequestParam(value="questionnaireCode") String questionnaireCode, @RequestParam(value="memberCode") String memberCode) {
        try {
            List<QuestionAnswerVo> result = this.questionnaireService.getQuestionAnswer(questionnaireCode, memberCode);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

