/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.RaffleManageService;
import com.biz.crm.member.business.member.sdk.dto.RaffleManageDto;
import com.biz.crm.member.business.member.sdk.dto.RaffleManagePageDto;
import com.biz.crm.member.business.member.sdk.vo.RaffleManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.RaffleManageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5927\u8f6c\u76d8\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/member/raffle"})
public class RaffleManageController {
    private static final Logger log = LoggerFactory.getLogger(RaffleManageController.class);
    @Autowired
    private RaffleManageService raffleManageService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<RaffleManagePageVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, RaffleManagePageDto pageDto) {
        try {
            Page<RaffleManagePageVo> result = this.raffleManageService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<RaffleManageVo> findDetailById(@RequestParam(value="id", required=false) String id, @RequestParam(value="code", required=false) String code) {
        try {
            RaffleManageVo viewpagerVo = this.raffleManageService.findDetailById(id, null);
            return Result.ok((Object)viewpagerVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<RaffleManageVo> create(@RequestBody RaffleManageDto raffleManageDto) {
        try {
            RaffleManageVo current = this.raffleManageService.create(raffleManageDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<RaffleManageVo> update(@RequestBody RaffleManageDto raffleManageDto) {
        try {
            RaffleManageVo current = this.raffleManageService.update(raffleManageDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.raffleManageService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.raffleManageService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PatchMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.raffleManageService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

