/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ViewpagerService;
import com.biz.crm.member.business.member.sdk.dto.ViewpagerDto;
import com.biz.crm.member.business.member.sdk.vo.ViewpagerVo;
import com.bizunited.nebula.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8f6e\u64ad\u56fe\u4e3b\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/member/viewpager"})
public class ViewpagerController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ViewpagerController.class);
    @Autowired
    private ViewpagerService viewpagerService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ViewpagerVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, ViewpagerDto pageDto) {
        try {
            Page<ViewpagerVo> result = this.viewpagerService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<ViewpagerVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            ViewpagerVo viewpagerVo = this.viewpagerService.findDetailById(id);
            return Result.ok((Object)viewpagerVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<ViewpagerVo> create(@RequestBody ViewpagerDto viewpagerDto) {
        try {
            ViewpagerVo current = this.viewpagerService.create(viewpagerDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<ViewpagerVo> update(@RequestBody ViewpagerDto viewpagerDto) {
        try {
            ViewpagerVo current = this.viewpagerService.update(viewpagerDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.viewpagerService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.viewpagerService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PatchMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        try {
            this.viewpagerService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

