/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.AppPointStoreService;
import com.biz.crm.member.business.member.sdk.dto.AppPointStoreDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.biz.crm.member.business.member.sdk.vo.ProductVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u79ef\u5206\u680f"})
@RestController
@RequestMapping(value={"/v1/app/point"})
public class AppPointStoreController {
    private static final Logger log = LoggerFactory.getLogger(AppPointStoreController.class);
    @Autowired
    AppPointStoreService appPointStoreService;

    @ApiOperation(value="\u5546\u54c1\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ProductPageVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, ProductPageDto pageDto) {
        try {
            Page<ProductPageVo> result = this.appPointStoreService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<ProductVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            ProductVo productVo = this.appPointStoreService.findDetailById(id);
            return Result.ok((Object)productVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79ef\u5206\u865a\u62df\u5546\u54c1\u5151\u6362")
    @PostMapping(value={"/exchangeVirtual"})
    public Result<?> exchangeVirtual(@RequestBody AppPointStoreDto dto) {
        try {
            this.appPointStoreService.exchangeVirtual(dto);
            return Result.ok((String)"\u5151\u6362\u6210\u529f\uff01");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

