/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ActivityManageService;
import com.biz.crm.member.business.member.local.service.InfoManageService;
import com.biz.crm.member.business.member.local.service.ViewpagerService;
import com.biz.crm.member.business.member.sdk.vo.ActivityManageVo;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import com.biz.crm.member.business.member.sdk.vo.ViewpagerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u9996\u9875"})
@RestController
@RequestMapping(value={"/v1/app/index"})
public class IndexAPIController {
    private static final Logger log = LoggerFactory.getLogger(IndexAPIController.class);
    @Autowired
    private ViewpagerService viewpagerService;
    @Autowired
    private ActivityManageService activityManageService;
    @Autowired
    private InfoManageService infoManageService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u9996\u9875\u8f6e\u64ad\u56fe\u83b7\u53d6,\u5e94\u7528\u533a\u57df,\u6570\u636e\u5b57\u5178:mms_use_area")
    @GetMapping(value={"/index/banner"})
    public Result<List<ViewpagerVo>> listIndexBanner(@RequestParam(value="code") String code) {
        try {
            List<ViewpagerVo> result = this.viewpagerService.getEnableOneByUseArea(code);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u9996\u9875(\u6d3b\u52a8\u4f01\u5212)")
    @GetMapping(value={"/index/activity/plan"})
    public Result<ActivityManageVo> getIndexActivityPlan() {
        try {
            ActivityManageVo result = this.activityManageService.getOneByEnableOrderBySignEndTime();
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u9996\u9875(\u8d44\u8baf\u7cbe\u9009)")
    @GetMapping(value={"/index/info"})
    public Result<List<InfoManageVo>> getIndexInfoLimitThree() {
        try {
            List<InfoManageVo> result = this.infoManageService.getAppIndexInfoLimitThree();
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

