/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.ChoiceNessCategoryService;
import com.biz.crm.member.business.member.local.service.DiscussService;
import com.biz.crm.member.business.member.local.service.InfoCategoryService;
import com.biz.crm.member.business.member.local.service.InfoManageService;
import com.biz.crm.member.business.member.local.service.InfoUpvoteService;
import com.biz.crm.member.business.member.local.service.ViewpagerService;
import com.biz.crm.member.business.member.sdk.dto.DiscussDto;
import com.biz.crm.member.business.member.sdk.enums.InfoApplyModelEnum;
import com.biz.crm.member.business.member.sdk.enums.UseAreaEnum;
import com.biz.crm.member.business.member.sdk.vo.ChoiceNessCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.DiscussVo;
import com.biz.crm.member.business.member.sdk.vo.InfoCategoryVo;
import com.biz.crm.member.business.member.sdk.vo.InfoManageVo;
import com.biz.crm.member.business.member.sdk.vo.ViewpagerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u8d44\u8baf"})
@RestController
@RequestMapping(value={"/v1/app/info/message"})
public class InfoAPIController {
    private static final Logger log = LoggerFactory.getLogger(InfoAPIController.class);
    @Autowired
    private InfoManageService infoManageService;
    @Autowired
    private InfoCategoryService infoCategoryService;
    @Autowired
    private ChoiceNessCategoryService choiceNessCategoryService;
    @Autowired
    private ViewpagerService viewpagerService;
    @Autowired
    private InfoUpvoteService infoUpvoteService;
    @Autowired
    private DiscussService discussService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u7aef\u83b7\u53d6\u8d44\u8baf\u5206\u7c7b(\u6839\u636e\u8d44\u8baf\u5206\u7c7b\u7684\u5e94\u7528\u8303\u56f4,\u5e94\u7528\u8303\u56f4\u6570\u636e\u5b57\u5178:mms_info_category)")
    @GetMapping(value={"/list/info/category"})
    public Result<List<InfoCategoryVo>> listEnableInfoCategory(@RequestParam(value="applyRange") String applyRange) {
        try {
            List<InfoCategoryVo> result = this.infoCategoryService.appListEnableInfoCategoryByApplyRange(applyRange);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u8d44\u8baf\u8f6e\u64ad\u56fe")
    @GetMapping(value={"/list/banner"})
    public Result<List<ViewpagerVo>> listInfoBanner() {
        try {
            List<ViewpagerVo> result = this.viewpagerService.getEnableOneByUseArea(UseAreaEnum.INFO.getCode());
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u7aef\u83b7\u53d6\u6709\u6548\u7684\u7cbe\u9009\u5206\u7c7b\u9650\u52363")
    @GetMapping(value={"/list/info/choice/category"})
    public Result<List<ChoiceNessCategoryVo>> listEnableChoiceNessCategory() {
        try {
            List<ChoiceNessCategoryVo> result = this.choiceNessCategoryService.appListEnableChoiceNessCategory();
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u7aef\u6839\u636e\u7cbe\u9009\u5206\u7c7b\u7f16\u7801\u83b7\u53d6\u6700\u65b0\u7684\u4e00\u4e2a\u8d44\u8baf")
    @GetMapping(value={"/get/info/choice/code/last"})
    public Result<InfoManageVo> getInfoByChoiceCodeLast(@RequestParam(value="choiceCategoryCode") String choiceCategoryCode) {
        try {
            InfoManageVo result = this.infoManageService.getInfoByChoiceCodeLast(choiceCategoryCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8d44\u8baf\u5217\u8868")
    @GetMapping(value={"/page"})
    public Result<Page<InfoManageVo>> pageInfoManageApp(@PageableDefault(value=50) Pageable pageable, @RequestParam(value="infoCategoryCode") String infoCategoryCode) {
        try {
            Page<InfoManageVo> result = this.infoManageService.pageInfoManageApp(pageable, infoCategoryCode, InfoApplyModelEnum.INFO_CHOICE_NESS.getValue());
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8d44\u8baf\u70b9\u8d5e")
    @GetMapping(value={"/info/upvote"})
    public Result upvoteInfoByCode(@RequestParam(value="infoCode") String infoCode) {
        try {
            this.infoUpvoteService.addInfoUpvote(infoCode);
            return Result.ok((String)"\u70b9\u8d5e\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8d44\u8baf\u53d6\u6d88\u70b9\u8d5e")
    @GetMapping(value={"/info/cancel/upvote"})
    public Result cancelUpvoteInfoByCode(@RequestParam(value="infoCode") String infoCode) {
        try {
            this.infoUpvoteService.logicDeleteUpvote(infoCode);
            return Result.ok((String)"\u53d6\u6d88\u70b9\u8d5e\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8d44\u8baf\u83b7\u53d6\u8be6\u60c5")
    @GetMapping(value={"/info/detail"})
    public Result<InfoManageVo> getIndexInfoDetailByInfoCode(@RequestParam(value="infoCode") String infoCode) {
        try {
            InfoManageVo result = this.infoManageService.appGetInfoDetailByCode(infoCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u662f\u5426\u53ef\u4ee5\u8bc4\u8bba")
    @GetMapping(value={"/info/discuss/enable"})
    public Result<Boolean> getEnableDiscuss() {
        try {
            Boolean result = this.discussService.enableDiscuss();
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u5f53\u524d\u8d44\u8baf\u7684\u8bc4\u8bba\u4fe1\u606f")
    @GetMapping(value={"/page/info/discuss"})
    public Result<Page<DiscussVo>> pageInfoDiscussByInfoCode(@PageableDefault(value=50) Pageable pageable, @RequestParam(value="infoCode") String infoCode) {
        try {
            Page<DiscussVo> result = this.discussService.appPageDiscussByInfoCode(pageable, infoCode);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u5f53\u524d\u8d44\u8baf\u81ea\u5df1\u7684\u6700\u65b03\u6761\u8bc4\u8bba")
    @GetMapping(value={"/list/discuss/owner"})
    public Result<List<DiscussVo>> listOwnerDiscuss(@RequestParam(value="infoCode") String infoCode) {
        try {
            List<DiscussVo> result = this.discussService.appListOwnerDiscussLimit(infoCode);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8d44\u8baf\u8bc4\u8bba\u65b0\u589e")
    @PostMapping(value={"/info/discuss"})
    public Result<DiscussVo> createDiscuss(@RequestBody DiscussDto dto) {
        try {
            DiscussVo result = this.discussService.createDiscuss(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8d44\u8baf\u5206\u4eab")
    @GetMapping(value={"/info/share"})
    public Result<InfoManageVo> appShareInfo(@RequestParam(value="infoCode") String infoCode) {
        try {
            InfoManageVo result = this.infoManageService.appShareInfoByCode(infoCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

