/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.BenefitsManageService;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.local.service.MemberInfoBenefitsService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelBenefitsVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelManageVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberHoneVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefits;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoBenefitsReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f-\u4f1a\u5458\u6743\u76ca\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/api/memberBenefits"})
public class MemberBenefitsController {
    private static final Logger log = LoggerFactory.getLogger(MemberBenefitsController.class);
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private BenefitsManageService benefitsManageService;
    @Autowired
    private LevelManageService levelManageService;
    @Autowired
    private MemberInfoService memberInfoService;
    @Autowired
    private MemberInfoBenefitsService memberInfoBenefitsService;

    @ApiOperation(value="\u6240\u6709\u4f1a\u5458\u7b49\u7ea7\u4fe1\u606f(\u5361\u7247tab)")
    @GetMapping(value={"/getMemberLevelAll"})
    public Result<List<AppletLevelManageVo>> getMemberLevelAll() {
        try {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            List<AppletLevelManageVo> appletLevelManageVos = this.levelManageService.getMemberLevelAll(memberCode);
            return Result.ok(appletLevelManageVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f1a\u5458\u6211\u7684\u9996\u9875 - \u67e5\u770b\u6743\u76ca(\u4f1a\u5458\u6743\u76ca)")
    @GetMapping(value={"/getMemberLevelInfo"})
    public Result<AppletMemberHoneVo> getMemberLevelInfo() {
        try {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            AppletMemberHoneVo appletMemberHoneVo = this.memberInfoService.getMemberLevelInfo(memberCode);
            return Result.ok((Object)appletMemberHoneVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f1a\u5458\u6743\u76ca\u5217\u8868\u4fe1\u606f")
    @GetMapping(value={"/getMemberBenefitsList"})
    public Result<List<AppletLevelBenefitsVo>> getMemberBenefitsList(@RequestParam(value="levelCode") String levelCode) {
        try {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            List<AppletLevelBenefitsVo> appletLevelBenefitsVos = this.levelManageService.getMemberBenefitsList(levelCode, memberCode);
            return Result.ok(appletLevelBenefitsVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f1a\u5458\u6743\u76ca\u5151\u6362")
    @GetMapping(value={"/getMemberInfoBenefitsList"})
    public Result<Page<AppletMemberInfoBenefits>> getMemberInfoBenefitsList(@PageableDefault(value=50) Pageable pageable, AppletMemberInfoBenefitsReqVo appletMemberInfoBenefitsReqVo) {
        try {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            appletMemberInfoBenefitsReqVo.setMemberCode(memberCode);
            Page<AppletMemberInfoBenefits> appletLevelBenefitsVos = this.memberInfoBenefitsService.getMemberInfoBenefitsList(pageable, appletMemberInfoBenefitsReqVo);
            return Result.ok(appletLevelBenefitsVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6743\u76ca\u5151\u6362\u8be6\u60c5")
    @GetMapping(value={"/getMemberInfoBenefitsDetailById"})
    public Result<AppletMemberInfoBenefits> getMemberInfoBenefitsDetailById(@RequestParam(value="id") String id) {
        try {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            AppletMemberInfoBenefits appletMemberInfoBenefits = this.memberInfoBenefitsService.getMemberInfoBenefitsDetailById(memberCode, id);
            return Result.ok((Object)appletMemberInfoBenefits);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6743\u76ca\u63d0\u4ea4\u5151\u6362")
    @PostMapping(value={"/getMemberInfoBenefitsSubmit"})
    public Result<AppletMemberInfoBenefits> getMemberInfoBenefitsSubmit(@RequestBody AppletMemberInfoBenefits appletMemberInfoBenefits) {
        try {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            appletMemberInfoBenefits.setMemberCode(memberCode);
            AppletMemberInfoBenefits result = this.memberInfoBenefitsService.getMemberInfoBenefitsSubmit(appletMemberInfoBenefits);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

