/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberHoneVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoReqVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f-\u4f1a\u5458\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/api/memberInfo"})
public class MemberInfoHomeController {
    private static final Logger log = LoggerFactory.getLogger(MemberInfoHomeController.class);
    @Autowired
    private MemberInfoService memberInfoService;
    @Autowired
    private UserSearchHelper userSearchHelper;

    @ApiOperation(value="\u4f1a\u5458\u57fa\u7840\u8d44\u6599")
    @GetMapping(value={"/getMemberInfo"})
    public Result<AppletMemberInfoVo> getMemberInfo() {
        try {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            AppletMemberInfoVo appletMemberInfoVo = this.memberInfoService.getMemberInfo(memberCode);
            return Result.ok((Object)appletMemberInfoVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f1a\u5458\u4fee\u6539\u751f\u65e5")
    @PostMapping(value={"/updMemberBirthday"})
    public Result updMemberBirthday(AppletMemberInfoReqVo appletMemberInfoReqVo) {
        try {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            appletMemberInfoReqVo.setMemberCode(memberCode);
            this.memberInfoService.updMemberBirthday(appletMemberInfoReqVo);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f1a\u5458\u6211\u7684\u9996\u9875\u4fe1\u606f")
    @GetMapping(value={"/getMemberHome"})
    public Result<AppletMemberHoneVo> getMemberHome() {
        try {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            AppletMemberHoneVo appletMemberHoneVo = this.memberInfoService.getMemberHome(memberCode);
            return Result.ok((Object)appletMemberHoneVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

