/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.MemberInfoSignService;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSignVo;
import com.biz.crm.member.business.member.sdk.vo.SignInfoVo;
import com.biz.crm.member.business.member.sdk.vo.SignResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u7b7e\u5230"})
@RestController
@RequestMapping(value={"/v1/app/member/sign"})
public class MemberSignAPIController {
    private static final Logger log = LoggerFactory.getLogger(MemberSignAPIController.class);
    @Autowired
    private MemberInfoSignService memberInfoSignService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u7b7e\u5230\u8bb0\u5f55\uff08\u4ec5\u4ec5\u53ea\u662f\u7b7e\u5230\u8bb0\u5f55\uff09,\u53c2\u6570\u65f6\u95f4\u7684\u4f20\u9012\u683c\u5f0f\u5fc5\u987b\u4e3a: yyyy-MM")
    @GetMapping(value={"/records"})
    public Result<List<MemberInfoSignVo>> listMemberInfoSign(@RequestParam(value="dateTime", required=false) String dateTime) {
        try {
            if (StringUtils.isBlank((CharSequence)dateTime)) {
                dateTime = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
            }
            List<MemberInfoSignVo> result = this.memberInfoSignService.listCurrentUserMemberInfoSign(dateTime);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u7b7e\u5230\u8bb0\u5f55\u4fe1\u606f\u9875\u9762\u5176\u4ed6\u4fe1\u606f,\u53c2\u6570\u65f6\u95f4\u7684\u4f20\u9012\u683c\u5f0f\u5fc5\u987b\u4e3a: yyyy-MM")
    @GetMapping(value={"/detail"})
    public Result<SignInfoVo> getSignDetail(@RequestParam(value="dateTime", required=false) String dateTime) {
        try {
            if (StringUtils.isBlank((CharSequence)dateTime)) {
                dateTime = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
            }
            SignInfoVo result = this.memberInfoSignService.getSignDetail(dateTime);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u7b7e\u5230")
    @GetMapping(value={"/sign/today"})
    public Result<SignResultVo> sign() {
        try {
            SignResultVo result = this.memberInfoSignService.appSign();
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

