/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.member.business.member.local.service.DummyOrderService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.local.service.RealOrderService;
import com.biz.crm.member.business.member.local.service.VerificationUserService;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.DispatchSalesmanDto;
import com.biz.crm.member.business.member.sdk.dto.VerificationRealOrderDto;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.PersonalCenterAPIVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import com.biz.crm.member.business.member.sdk.vo.VerificationUserVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5c0f\u7a0b\u5e8f\u4e2a\u4eba\u4e2d\u5fc3"})
@RequestMapping(value={"/v1/app/personal/center"})
public class PersonalCenterAPIController {
    private static final Logger log = LoggerFactory.getLogger(PersonalCenterAPIController.class);
    @Autowired
    private DummyOrderService dummyOrderService;
    @Autowired
    private RealOrderService realOrderService;
    @Autowired(required=false)
    private MemberInfoService memberInfoService;
    @Autowired
    private VerificationUserService verificationUserService;
    @Autowired
    private RedissonClient redissonClient;

    @ApiOperation(value="\u6211\u7684\u540d\u7247")
    @GetMapping(value={"/queryMyCard"})
    public Result<PersonalCenterAPIVo> queryMyCard() {
        try {
            PersonalCenterAPIVo personalCenterAPIVo = this.memberInfoService.queryMemberAssociationInfoCard();
            return Result.ok((Object)personalCenterAPIVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8d2d\u9152\u670d\u52a1")
    @GetMapping(value={"/purchaseAlcohol"})
    public Result<PersonalCenterAPIVo> purchaseAlcohol() {
        try {
            PersonalCenterAPIVo personalCenterAPIVo = this.memberInfoService.queryMemberAssociationInfo();
            return Result.ok((Object)personalCenterAPIVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u865a\u62df\u8ba2\u5355", notes="\u5f53\u8ba2\u5355\u72b6\u6001orderStatus\u4e3a\u5f85\u6838\u9500||\u5373\u5c06\u8fc7\u671f\u65f6\u5c55\u793a'\u51fa\u793a\u6838\u9500\u7801\u6309\u94ae'")
    @GetMapping(value={"/page/dummy/order"})
    public Result<Page<DummyOrderVo>> pageUserDummyOrder(@PageableDefault(value=50) Pageable pageable, AppOrderPaginationDto dto) {
        try {
            Page<DummyOrderVo> result = this.dummyOrderService.appPageDummyOrder(pageable, dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u5b9e\u7269\u8ba2\u5355", notes="\u5f53\u8ba2\u5355\u72b6\u6001orderStatus\u4e3a\u914d\u9001\u4e2d\u65f6\u5c55\u793a\u2018\u51fa\u793a\u6838\u9500\u7801\u6309\u94ae\u2019")
    @GetMapping(value={"/page/real/order"})
    public Result<Page<RealOrderVo>> pageUserRealOrder(@PageableDefault(value=50) Pageable pageable, AppOrderPaginationDto dto) {
        try {
            Page<RealOrderVo> result = this.realOrderService.appPageRealOrder(pageable, dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u865a\u62df\u6838\u9500")
    @GetMapping(value={"/dummy/order/write"})
    public Result writeDummyOrder(@RequestParam(value="dummyOrderId") String dummyOrderId) {
        Validate.notBlank((CharSequence)dummyOrderId, (String)"\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String lockKey = String.format("dummy:order:lock:%s", dummyOrderId);
        RLock rLock = this.redissonClient.getLock(lockKey);
        boolean lockFlag = rLock.tryLock();
        Validate.isTrue((boolean)lockFlag, (String)"\u5f53\u524d\u8ba2\u5355\u6b63\u5728\u6838\u9500\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            this.dummyOrderService.writeDummyOrderById(dummyOrderId);
            Result result = Result.ok((String)"\u865a\u62df\u8ba2\u5355\u6838\u9500\u6210\u529f");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            rLock.unlock();
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u865a\u62df\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/dummy/order/detail"})
    public Result<DummyOrderVo> dummyOrderDetailById(@RequestParam(value="dummyOrderId") String dummyOrderId) {
        try {
            DummyOrderVo result = this.dummyOrderService.findDetailById(dummyOrderId);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e1a\u52a1\u5458\u83b7\u53d6\u81ea\u5df1\u7684\u914d\u9001\u8ba2\u5355&\u914d\u9001\u8ba2\u5355\u590d\u7528")
    @GetMapping(value={"/page/delivery/order"})
    public Result<Page<RealOrderVo>> pageDeliveryOrder(@PageableDefault(value=50) Pageable pageable, @RequestParam(value="orderStatus") String orderStatus) {
        try {
            Page<RealOrderVo> result = this.realOrderService.appPageDeliveryOrder(pageable, orderStatus);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u53d1\u8ba2\u5355")
    @GetMapping(value={"/dispatch/order"})
    public Result<Page<RealOrderVo>> pageDispatchOrder(@PageableDefault(value=50) Pageable pageable, @RequestParam(value="orderStatus") String orderStatus) {
        try {
            Page<RealOrderVo> result = this.realOrderService.appPageDispatchOrder(pageable, orderStatus);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u53d1\u4e1a\u52a1\u5458\u540d\u5355")
    @GetMapping(value={"/list/dispatch/salesman"})
    public Result<List<VerificationUserVo>> listDispatchSalesman() {
        try {
            List<VerificationUserVo> result = this.verificationUserService.listDispatchSalesman();
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e3a\u8ba2\u5355\u5206\u53d1\u4e1a\u52a1\u5458")
    @PostMapping(value={"/dispatch/salesman/for/order"})
    public Result dispatchSalesmanForOrder(@RequestBody DispatchSalesmanDto dto) {
        try {
            this.realOrderService.appDispatchSalesmanForOrder(dto);
            return Result.ok((String)"\u5206\u53d1\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5b9e\u7269\u6838\u9500")
    @PostMapping(value={"/real/order/write"})
    public Result writeRealOrder(@RequestBody VerificationRealOrderDto dto) {
        this.validateRealOrderVerification(dto);
        String realOrderId = dto.getVerificationOrderId();
        String lockKey = String.format("real:order:lock:%s", realOrderId);
        RLock rLock = this.redissonClient.getLock(lockKey);
        boolean lockFlag = rLock.tryLock();
        Validate.isTrue((boolean)lockFlag, (String)"\u5f53\u524d\u8ba2\u5355\u6b63\u5728\u6838\u9500\u4e2d,\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            this.realOrderService.appWriteOrderById(dto);
            Result result = Result.ok((String)"\u6838\u9500\u6210\u529f");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            rLock.unlock();
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7ecf\u9500\u5546")
    @GetMapping(value={"/list/agent"})
    public Result<List<CustomerVo>> listCustomer() {
        try {
            List<CustomerVo> result = this.realOrderService.appListAgentCustomer();
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5b9e\u7269\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/real/order/id"})
    public Result<RealOrderVo> getRealOrderById(@RequestParam(value="realOrderId") String realOrderId) {
        try {
            RealOrderVo result = this.realOrderService.findDetailById(realOrderId);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53bb\u914d\u9001")
    @GetMapping(value={"/real/order/delivery"})
    public Result deliveryOrder(@RequestParam(value="orderId") String orderId) {
        try {
            this.realOrderService.appDeliveryOrderById(orderId);
            return Result.ok((String)"\u914d\u9001\u4e2d");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    private void validateRealOrderVerification(VerificationRealOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String realOrderId = dto.getVerificationOrderId();
        Validate.notBlank((CharSequence)realOrderId, (String)"\u6838\u9500\u4eba\u5458\u63d0\u4f9b\u7684\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String customerOrderId = dto.getCustomerOrderId();
        Validate.notBlank((CharSequence)customerOrderId, (String)"\u5ba2\u6237\u63d0\u4f9b\u7684\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)realOrderId.equals(customerOrderId), (String)"\u5ba2\u6237\u63d0\u4f9b\u7684\u8ba2\u5355\u4fe1\u606f\u4e0d\u5339\u914d,\u6838\u9500\u5931\u8d25", (Object[])new Object[0]);
    }
}

