/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.QuestionnaireService;
import com.biz.crm.member.business.member.sdk.dto.QuestionnaireSubmitDto;
import com.biz.crm.member.business.member.sdk.vo.QuestionAnswerVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireDetailVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u8c03\u67e5\u95ee\u5377"})
@RestController
@RequestMapping(value={"/v1/app/questionnaire"})
public class QuestionnaireAPIController {
    private static final Logger log = LoggerFactory.getLogger(QuestionnaireAPIController.class);
    @Autowired
    private QuestionnaireService questionnaireService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8c03\u67e5\u95ee\u5377\u5217\u8868,\u6570\u636e\u5b57\u5178\uff1amms_app_questionnaire; rangeStatus\u5c5e\u6027\u7684\u503c\uff0c\u4ece\u8be5\u5b57\u5178\u4e2d\u83b7\u53d6")
    @GetMapping(value={"/page/questionnaire"})
    public Result<Page<QuestionnaireVo>> pageQuestionnaireInfoWithStatus(@PageableDefault(value=50) Pageable pageable, @RequestParam(value="rangeStatus") String rangeStatus) {
        try {
            Page<QuestionnaireVo> result = this.questionnaireService.pageQuestionnaireWithStatus(pageable, rangeStatus);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8c03\u67e5\u95ee\u5377\u8be6\u60c5")
    @GetMapping(value={"/questionnaire/detail"})
    public Result<QuestionnaireDetailVo> getQuestionnaireDetail(@RequestParam(value="questionnaireCode") String questionnaireCode) {
        try {
            QuestionnaireDetailVo result = this.questionnaireService.getQuestionnaireDetailByCode(questionnaireCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u67e5\u770b\u8c03\u67e5\u95ee\u5377\u7b54\u5377")
    @GetMapping(value={"/questionnaire/detail/submit"})
    public Result<List<QuestionAnswerVo>> getQuestionnaireDetailBySubmit(@RequestParam(value="questionnaireCode") String questionnaireCode) {
        try {
            List<QuestionAnswerVo> result = this.questionnaireService.getQuestionnaireDetailBySubmit(questionnaireCode);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u63d0\u4ea4\u95ee\u5377")
    @PostMapping(value={"/submit/questionnaire"})
    public Result<QuestionnaireVo> submitQuestionnaire(@RequestBody List<QuestionnaireSubmitDto> dtoList) {
        try {
            QuestionnaireVo result = this.questionnaireService.submitQuestionnaire(dtoList);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

