/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.service.RewardActivityLotteryService;
import com.biz.crm.member.business.member.sdk.dto.LotteryDto;
import com.biz.crm.member.business.member.sdk.dto.RafflePrizeRecordDto;
import com.biz.crm.member.business.member.sdk.vo.LotteryVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeDetailsVo;
import com.biz.crm.member.business.member.sdk.vo.RafflePrizeRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u5927\u8f6c\u76d8\u6d3b\u52a8\u62bd\u5956"})
@RestController
@RequestMapping(value={"/v1/api/activity/lottery"})
public class RewardActivityLotteryController {
    private static final Logger log = LoggerFactory.getLogger(RewardActivityLotteryController.class);
    @Autowired
    private RewardActivityLotteryService rewardActivityLotteryService;

    @ApiOperation(value="\u4e2d\u5956\u8bb0\u5f55(\u5f53\u524d\u767b\u5f55\u4eba)")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<RafflePrizeRecordVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, RafflePrizeRecordDto rafflePrizeRecordDto) {
        try {
            Page<RafflePrizeRecordVo> result = this.rewardActivityLotteryService.findByConditions(pageable, rafflePrizeRecordDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u89c4\u5219")
    @GetMapping(value={"/getRuleDes"})
    public Result<String> getRuleDes(@RequestParam(value="activityCode") String activityCode) {
        try {
            String ruleDes = this.rewardActivityLotteryService.getRuleDes(activityCode);
            Result result = Result.ok((String)"");
            result.setResult((Object)ruleDes);
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7528\u6237\u5269\u4f59\u62bd\u5956\u6b21\u6570/\u6bcf\u6b21\u6d88\u8017\u79ef\u5206/\u5927\u8f6c\u76d8\u914d\u7f6e")
    @GetMapping(value={"/rewardInfo"})
    public Result<LotteryVo> rewardInfo(@RequestParam(value="activityCode") String activityCode) {
        try {
            LotteryVo lotteryVo = this.rewardActivityLotteryService.rewardInfo(activityCode);
            return Result.ok((Object)lotteryVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62bd\u5956")
    @PostMapping(value={"lottery"})
    public Result<RafflePrizeDetailsVo> lottery(@RequestBody LotteryDto lotteryDto) {
        try {
            RafflePrizeDetailsVo current = this.rewardActivityLotteryService.lottery(lotteryDto);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

