/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.service.AddressManageService;
import com.biz.crm.member.business.member.local.service.AppletPopupNotifyService;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.local.service.MessageNotifyService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.sdk.dto.AddressManagePaginationDto;
import com.biz.crm.member.business.member.sdk.dto.MessageNotifyPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsTypeEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerConditionEnum;
import com.biz.crm.member.business.member.sdk.enums.TriggerTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.AddressManageVo;
import com.biz.crm.member.business.member.sdk.vo.MessageNotifyVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletMemberBaseInfoVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletPopupNotifyVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletSystemSettingsServiceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u4e2a\u4eba\u4e2d\u5fc3-\u7cfb\u7edf\u8bbe\u7f6e\u63a7\u5236\u5c42"})
@RestController
@RequestMapping(value={"/v1/api/systemSettingAPI"})
public class SystemSettingAPIController {
    private static final Logger log = LoggerFactory.getLogger(SystemSettingAPIController.class);
    @Autowired
    private MemberInfoService memberInfoService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private AddressManageService addressManageService;
    @Autowired
    private SystemSettingsDetailService systemSettingsDetailService;
    @Autowired
    private MemberInfoIntegralRecordService memberInfoIntegralRecordService;
    @Autowired
    private AppletPopupNotifyService appletPopupNotifyService;
    @Autowired
    private MessageNotifyService messageNotifyService;

    @ApiOperation(value="\u4e2a\u4eba\u4fe1\u606f\u67e5\u770b")
    @GetMapping(value={"/personalInfo"})
    public Result<AppletMemberBaseInfoVo> findPersonalInfo() {
        try {
            AppletMemberBaseInfoVo result = this.memberInfoService.findBaseInfoByMemberCode(this.userSearchHelper.getMemberLogin().getMemberCode());
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e2a\u4eba\u4fe1\u606f\u4fee\u6539,\u4e00\u6b21\u4fee\u6539\u4e00\u9879,\u53ea\u586b\u4e00\u9879\u7684\u503c")
    @GetMapping(value={"/updatePersonalInfo"})
    public Result<AppletMemberBaseInfoVo> updatePersonalInfo(AppletMemberBaseInfoVo appletMemberBaseInfoVo) {
        try {
            AppletMemberBaseInfoVo result = this.memberInfoService.updateBase(appletMemberBaseInfoVo);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u5730\u5740\u4fe1\u606f\u5206\u9875")
    @GetMapping(value={"/addressInfo"})
    public Result<Page<AddressManageVo>> addressInfo(@PageableDefault(value=50) Pageable pageable, AddressManagePaginationDto pageDto) {
        try {
            Page<AddressManageVo> result = this.addressManageService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa\u5730\u5740\u4fe1\u606f")
    @PostMapping(value={"/createAddress"})
    public Result<AddressManageVo> createAddress(@RequestBody AddressManageVo addressManageVo) {
        try {
            AddressManageVo current = this.addressManageService.create(addressManageVo);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u5730\u5740\u4fe1\u606f")
    @PostMapping(value={"/updateAddress"})
    public Result<AddressManageVo> updateAddress(@RequestBody AddressManageVo addressManageVo) {
        try {
            AddressManageVo current = this.addressManageService.update(addressManageVo);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5730\u5740\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<AddressManageVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            AddressManageVo addressManageVo = this.addressManageService.findDetailById(id);
            return Result.ok((Object)addressManageVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u5730\u5740")
    @GetMapping(value={"/setDefault"})
    public Result setDefault(@RequestParam(value="id") String id) {
        try {
            this.addressManageService.setDefault(id);
            return Result.ok((String)"\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u5730\u5740\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u5730\u5740")
    @GetMapping(value={"/deleteAddress"})
    public Result deleteAddress(@RequestParam(value="id") String id) {
        try {
            this.addressManageService.updateDelFlagById(id);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u670d\u914d\u7f6e")
    @GetMapping(value={"/customerConf"})
    public Result<AppletSystemSettingsServiceVo> customerConf() {
        try {
            AppletSystemSettingsServiceVo current = this.systemSettingsDetailService.findByType(SystemSettingsTypeEnum.CUSTOMER_SERVICE_CONFIG.getValue());
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5f39\u7a97")
    @GetMapping(value={"/selectOne"})
    public Result<AppletPopupNotifyVo> selectOne() {
        try {
            AppletPopupNotifyVo appletPopupNotifyVo = this.appletPopupNotifyService.selectOne();
            return Result.ok((Object)appletPopupNotifyVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u6d88\u606f\u901a\u77e5\u5206\u9875")
    @GetMapping(value={"/findMessageByCondition"})
    public Result<Page<MessageNotifyVo>> findMessageByCondition(@PageableDefault(value=50) Pageable pageable, MessageNotifyPaginationDto pageDto) {
        try {
            Page<MessageNotifyVo> result = this.messageNotifyService.findByConditions(pageable, pageDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u589e\u52a0\u6d88\u606f\u901a\u77e5")
    @PostMapping(value={"/createMsgNotify"})
    public Result createMsgNotify(@RequestBody MessageNotifyVo messageNotifyVo) {
        try {
            this.messageNotifyService.create(messageNotifyVo);
            return Result.ok((String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5")
    @GetMapping(value={"/test"})
    public Result test() {
        try {
            AppletPopupNotifyVo appletPopupNotifyVo = new AppletPopupNotifyVo();
            appletPopupNotifyVo.setMemberCode(this.userSearchHelper.getMemberLogin().getMemberCode());
            appletPopupNotifyVo.setTriggerType(TriggerTypeEnum.LEVEL.getCode());
            appletPopupNotifyVo.setTriggerConditions(TriggerConditionEnum.LEVEL_EXPIRED.getCode());
            this.appletPopupNotifyService.addOne(appletPopupNotifyVo);
            return Result.ok((String)"current");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

