/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.business.member.local.entity.SystemSettingsDetail;
import com.biz.crm.member.business.member.local.service.CardProductService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.local.service.TouristAPIService;
import com.biz.crm.member.business.member.sdk.dto.CardProductDto;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.vo.CardProductVo;
import com.biz.crm.member.business.member.sdk.vo.TouristAPIVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u6e38\u5ba2"})
@RestController
@RequestMapping(value={"/v1/api/touristAPI"})
public class TouristAPIController {
    private static final Logger log = LoggerFactory.getLogger(TouristAPIController.class);
    @Autowired(required=false)
    private CardProductService cardProductService;
    @Autowired
    private TouristAPIService touristAPIService;
    @Autowired
    private SystemSettingsDetailService systemSettingsDetailService;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u6e38\u5ba2\u4ea7\u54c1\u4ecb\u7ecd\u5206\u9875")
    @GetMapping(value={"/findAll"})
    public Result<Page<CardProductVo>> findByConditions(@PageableDefault(value=50) Pageable pageable) {
        try {
            CardProductDto cardProductDto = new CardProductDto();
            Page<CardProductVo> result = this.cardProductService.findByConditions(pageable, cardProductDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u516c\u53f8\u4ecb\u7ecd")
    @GetMapping(value={"/companyDesc"})
    public Result<TouristAPIVo> companyDesc() {
        try {
            SystemSettingsDetail valueByKey = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.CARD_PAGE_COMPANY_PROFILE.getValue());
            TouristAPIVo touristAPIVo = new TouristAPIVo();
            touristAPIVo.setCompanyDesc(valueByKey.getTypeValueText());
            return Result.ok((Object)touristAPIVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5361\u7247\u4fe1\u606f")
    @GetMapping(value={"/cardInfo"})
    public Result<TouristAPIVo> cardInfo() {
        try {
            TouristAPIVo touristAPIVo = this.touristAPIService.cardInfo();
            return Result.ok((Object)touristAPIVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

