/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.observer;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.member.business.member.local.entity.ActivityApplyRecord;
import com.biz.crm.member.business.member.local.entity.ActivityManage;
import com.biz.crm.member.business.member.local.repository.ActivityApplyRecordRepository;
import com.biz.crm.member.business.member.local.repository.ActivityManageRepository;
import com.biz.crm.member.business.member.local.service.ActivityApplyRecordService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class ProcessCompleteListenerOfActivity
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessCompleteListenerOfActivity.class);
    @Autowired
    ActivityApplyRecordService activityApplyRecordService;
    @Autowired
    ActivityApplyRecordRepository activityApplyRecordRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ActivityManageRepository activityManageRepository;

    public String getBusinessCode() {
        return "APPLET_ACT_WORK_FLOW";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        if (!dto.getBusinessCode().equals("APPLET_ACT_WORK_FLOW")) {
            return;
        }
        ActivityApplyRecord recordVo = (ActivityApplyRecord)((Object)this.activityApplyRecordRepository.getById((Serializable)((Object)dto.getBusinessNo())));
        Validate.notNull((Object)((Object)recordVo), (String)"\u62a5\u540d\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessStatus()), (CharSequence)ProcessStatusEnum.PASS.getDictCode())) {
            recordVo.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        } else if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessStatus()), (CharSequence)ProcessStatusEnum.REJECT.getDictCode())) {
            recordVo.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
        } else if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessStatus()), (CharSequence)ProcessStatusEnum.RECOVER.getDictCode())) {
            recordVo.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
        }
        recordVo.setApprovalDate(new Date());
        this.activityApplyRecordRepository.updateById((Object)recordVo);
        if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessStatus()), (CharSequence)ProcessStatusEnum.PASS.getDictCode())) {
            boolean locked = false;
            try {
                locked = this.redisMutexService.tryLock(recordVo.getActivityCode(), TimeUnit.SECONDS, 5);
                Validate.isTrue((boolean)locked, (String)"\u4e1a\u52a1\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002", (Object[])new Object[0]);
                ActivityManage act = (ActivityManage)((Object)((LambdaQueryChainWrapper)this.activityManageRepository.lambdaQuery().eq(ActivityManage::getCode, (Object)recordVo.getActivityCode())).one());
                Integer currentCount = (Integer)ObjectUtils.defaultIfNull((Object)act.getHasJoin(), (Object)0);
                Validate.isTrue((currentCount < act.getApplyCeilingNum() ? 1 : 0) != 0, (String)"\u62b1\u6b49\uff0c\u62a5\u540d\u540d\u989d\u5df2\u7528\u5b8c\uff01", (Object[])new Object[0]);
                act.setHasJoin(currentCount + 1);
                this.activityManageRepository.saveOrUpdate((Object)act);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (locked) {
                    this.redisMutexService.unlock(recordVo.getActivityCode());
                }
            }
        }
    }
}

