/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.observer;

import com.biz.crm.member.business.member.local.entity.RealOrder;
import com.biz.crm.member.business.member.local.repository.RealOrderRepository;
import com.biz.crm.member.business.member.sdk.enums.OrderSettleStatusEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.io.Serializable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProcessCompleteListenerOfRealOrder
implements ProcessCompleteListener {
    @Autowired(required=false)
    private RealOrderRepository realOrderRepository;

    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {
        if (!dto.getBusinessCode().equals("mms_real_order_create")) {
            return;
        }
        RealOrder realOrder = (RealOrder)((Object)this.realOrderRepository.getById((Serializable)((Object)dto.getBusinessNo())));
        if (ObjectUtils.isEmpty((Object)((Object)realOrder))) {
            return;
        }
        Validate.isTrue((boolean)realOrder.getProcessStatus().equals(ProcessStatusEnum.COMMIT.getDictCode()), (String)"\u6b64\u5b9e\u7269\u8ba2\u5355\u975e\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessStatus()), (CharSequence)ProcessStatusEnum.PASS.getDictCode())) {
            realOrder.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            realOrder.setSettleStatus(OrderSettleStatusEnum.HAS_SETTLE.getValue());
        } else if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessStatus()), (CharSequence)ProcessStatusEnum.REJECT.getDictCode())) {
            realOrder.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
            realOrder.setSettleStatus(OrderSettleStatusEnum.REJECT_SETTLE.getValue());
        } else if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessStatus()), (CharSequence)ProcessStatusEnum.RECOVER.getDictCode())) {
            realOrder.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
            realOrder.setSettleStatus(OrderSettleStatusEnum.REJECT_SETTLE.getValue());
        }
        this.realOrderRepository.updateById((Object)realOrder);
    }

    public String getBusinessCode() {
        return "mms_real_order_create";
    }
}

