/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.MemberInfoIntegralRecord;
import com.biz.crm.member.business.member.local.mapper.MemberInfoIntegralRecordMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationAPIDto;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoIntegralRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordAPIVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class MemberInfoIntegralRecordRepository
extends ServiceImpl<MemberInfoIntegralRecordMapper, MemberInfoIntegralRecord> {
    public Page<MemberInfoIntegralRecordVo> findByConditions(Page<MemberInfoIntegralRecordVo> page, MemberInfoIntegralRecordPaginationDto dto) {
        return ((MemberInfoIntegralRecordMapper)this.baseMapper).findByConditions(page, dto);
    }

    public Page<MemberInfoIntegralRecordAPIVo> findByConditionsAPI(Page<MemberInfoIntegralRecordAPIVo> page, MemberInfoIntegralRecordPaginationAPIDto dto) {
        return ((MemberInfoIntegralRecordMapper)this.baseMapper).findByConditionsAPI(page, dto);
    }

    public MemberInfoIntegralRecord findById(String id) {
        return (MemberInfoIntegralRecord)((Object)((MemberInfoIntegralRecordMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<MemberInfoIntegralRecord> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public int sumResidualIntegral(String memberCode, Date timeOpen, Date timeClose) {
        return Optional.ofNullable(((MemberInfoIntegralRecordMapper)this.baseMapper).sumResidualIntegral(memberCode, timeOpen, timeClose)).orElse(0);
    }

    public int sumIntegralByTypeAndTime(List<String> addType, String currentTime) {
        return ((MemberInfoIntegralRecordMapper)this.baseMapper).sumIntegralByTypeAndTime(addType, currentTime, DelFlagStatusEnum.NORMAL.getCode());
    }
}

