/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.repository;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.MemberInfoSign;
import com.biz.crm.member.business.member.local.mapper.MemberInfoSignMapper;
import com.biz.crm.member.business.member.sdk.dto.MemberInfoSignPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoSignVo;
import com.biz.crm.member.business.member.sdk.vo.MemberSignCountVo;
import com.biz.crm.member.business.member.sdk.vo.MemberSignRecordVo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class MemberInfoSignRepository
extends ServiceImpl<MemberInfoSignMapper, MemberInfoSign> {
    public Page<MemberInfoSignVo> findByConditions(Page<MemberInfoSignVo> page, MemberInfoSignPaginationDto dto) {
        return ((MemberInfoSignMapper)this.baseMapper).findByConditions(page, dto);
    }

    public MemberInfoSign findById(String id) {
        return (MemberInfoSign)((Object)((MemberInfoSignMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<MemberInfoSign> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public MemberSignCountVo signCountNum() {
        return ((MemberInfoSignMapper)this.baseMapper).signCountNum();
    }

    public MemberSignRecordVo querySignCountNum(MemberInfoSignPaginationDto memberInfoSignPaginationDto) {
        return ((MemberInfoSignMapper)this.baseMapper).querySignCountNum(memberInfoSignPaginationDto);
    }

    public List<MemberInfoSign> listMemberInfoSign(String dateTime, String memberCode, Boolean orderAsc) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(MemberInfoSign::getMemberCode, (Object)memberCode)).likeRight(MemberInfoSign::getSignTime, (Object)dateTime)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).orderByAsc(orderAsc.booleanValue(), (Object[])new SFunction[]{MemberInfoSign::getSignTime})).orderByDesc(orderAsc == false, (Object[])new SFunction[]{MemberInfoSign::getSignTime});
        List memberInfoSignList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)memberInfoSignList)) {
            return Collections.EMPTY_LIST;
        }
        return memberInfoSignList;
    }

    public Integer countUserYearIntegral(String memberCode) {
        int currentYear = DateTime.of((long)System.currentTimeMillis()).year();
        return ((MemberInfoSignMapper)this.baseMapper).countUserYearIntegral(memberCode, currentYear);
    }

    public List<MemberInfoSign> listExtendIntegralSign(String monthTime, String memberCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(MemberInfoSign::getMemberCode, (Object)memberCode)).isNotNull(MemberInfoSign::getExtendObtain)).isNotNull(MemberInfoSign::getContinueDay)).likeRight(MemberInfoSign::getSignTime, (Object)monthTime);
        return this.list((Wrapper)queryWrapper);
    }
}

