/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.Questionnaire;
import com.biz.crm.member.business.member.local.mapper.QuestionnaireMapper;
import com.biz.crm.member.business.member.sdk.dto.QuestionnairePaginationDto;
import com.biz.crm.member.business.member.sdk.enums.QuestionnaireStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.QuestionnaireVo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class QuestionnaireRepository
extends ServiceImpl<QuestionnaireMapper, Questionnaire> {
    public Questionnaire getByCode(String code) {
        LambdaQueryWrapper questionnaireQuery = new LambdaQueryWrapper();
        questionnaireQuery.eq(Questionnaire::getCode, (Object)code);
        Questionnaire questionnaire = (Questionnaire)((Object)this.getOne((Wrapper)questionnaireQuery));
        return questionnaire;
    }

    public Page<QuestionnaireVo> pageInfo(Page<QuestionnaireVo> page, QuestionnairePaginationDto dto) {
        Page<QuestionnaireVo> result = ((QuestionnaireMapper)this.baseMapper).pageInfo(page, dto, DelFlagStatusEnum.NORMAL.getCode());
        return result;
    }

    public Page<QuestionnaireVo> appPageByPubStatusWithEnableStatus(Page<QuestionnaireVo> page, String pubStatus, List<String> submitQuestionnaireCodes) {
        return ((QuestionnaireMapper)this.baseMapper).appPageByPubStatusWithEnableStatus(page, pubStatus, EnableStatusEnum.ENABLE.getCode(), DelFlagStatusEnum.NORMAL.getCode(), QuestionnaireStatusEnum.NO_PUBLISH.getValue(), submitQuestionnaireCodes);
    }

    public void logicDelete(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    public void modifyEnableStatus(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).in(UuidEntity::getId, ids)).update();
    }

    public void modifyQuestionnaireStatus(String questionnaireCode, QuestionnaireStatusEnum statusEnum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Questionnaire::getPubStatus, (Object)statusEnum.getValue())).eq(Questionnaire::getCode, (Object)questionnaireCode)).update();
    }

    public Page<QuestionnaireVo> pageQuestionnaireByUserAccount(Page<QuestionnaireVo> page, String userAccount) {
        Page<QuestionnaireVo> result = ((QuestionnaireMapper)this.baseMapper).pageQuestionnaireByUserAccount(page, userAccount, DelFlagStatusEnum.NORMAL.getCode());
        return result;
    }

    public void generatePubStatus(List<QuestionnaireVo> records) {
        Date currentTime = new Date(System.currentTimeMillis());
        for (QuestionnaireVo questionnaire : records) {
            String pubStatus;
            Date startTime = questionnaire.getStartTime();
            Date endTime = questionnaire.getEndTime();
            switch (pubStatus = questionnaire.getPubStatus()) {
                case "no_started": {
                    if (!startTime.after(currentTime)) break;
                    questionnaire.setPubStatus(QuestionnaireStatusEnum.RUNNING.getValue());
                    break;
                }
                case "running": {
                    if (!endTime.before(currentTime)) break;
                    questionnaire.setPubStatus(QuestionnaireStatusEnum.FINISH.getValue());
                }
            }
        }
    }

    public void batchModifyQuestionnairePubStatus(Collection<String> questionnaireCodes, QuestionnaireStatusEnum statusEnum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Questionnaire::getPubStatus, (Object)statusEnum.getValue())).in(Questionnaire::getCode, questionnaireCodes)).update();
    }
}

