/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.RealOrder;
import com.biz.crm.member.business.member.local.mapper.RealOrderMapper;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.RealAndDummyOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.RealOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.RealOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.RealOrderTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.RealAndDummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class RealOrderRepository
extends ServiceImpl<RealOrderMapper, RealOrder> {
    public Page<RealOrderVo> findByConditions(Page<RealOrderVo> page, RealOrderPaginationDto dto) {
        return ((RealOrderMapper)this.baseMapper).findByConditions(page, dto);
    }

    public RealOrder findById(String id) {
        return (RealOrder)((Object)((RealOrderMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<RealOrder> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void changeTotalOrder(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(RealOrder::getOrderType, (Object)RealOrderTypeEnum.MARKET_ORDER.getValue())).set(RealOrder::getOrderType, (Object)RealOrderTypeEnum.TOTAL_ORDER.getValue())).set(RealOrder::getOrderStatus, (Object)RealOrderStatusEnum.STAY_SHIP.getValue())).update();
    }

    public void changeMarketOrder(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(RealOrder::getOrderType, (Object)RealOrderTypeEnum.TOTAL_ORDER.getValue())).set(RealOrder::getOrderType, (Object)RealOrderTypeEnum.MARKET_ORDER.getValue())).set(RealOrder::getOrderStatus, (Object)RealOrderStatusEnum.STAY_DELIVERY.getValue())).update();
    }

    public Page<RealOrderVo> appPageRealOrder(Page<RealOrderVo> page, AppOrderPaginationDto dto, String memberCode) {
        return ((RealOrderMapper)this.baseMapper).appPageRealOrder(page, dto, memberCode, DelFlagStatusEnum.NORMAL.getCode());
    }

    public Page<RealOrderVo> appPageRealOrderBySalesmanCode(Page<RealOrderVo> page, String orderStatus, String salesmanCode) {
        return ((RealOrderMapper)this.baseMapper).appPageRealOrderBySalesmanCode(page, orderStatus, salesmanCode, DelFlagStatusEnum.NORMAL.getCode());
    }

    public Page<RealOrderVo> appPageDispatchOrder(Page<RealOrderVo> page, String orderStatus, String orgCode) {
        return ((RealOrderMapper)this.baseMapper).appPageDispatchOrder(page, orderStatus, orgCode, DelFlagStatusEnum.NORMAL.getCode());
    }

    public Page<RealAndDummyOrderVo> findByConditionsRealAndOrder(Page<RealAndDummyOrderVo> page, RealAndDummyOrderPaginationDto dto) {
        return ((RealOrderMapper)this.baseMapper).findByConditionsRealAndOrder(page, dto);
    }
}

