/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.ActivityApplyRecord;
import com.biz.crm.member.business.member.local.entity.ActivityManage;
import com.biz.crm.member.business.member.local.repository.ActivityApplyRecordRepository;
import com.biz.crm.member.business.member.local.repository.ActivityManageRepository;
import com.biz.crm.member.business.member.local.service.ActivityApplyRecordService;
import com.biz.crm.member.business.member.sdk.dto.ActivityApplyRecordDto;
import com.biz.crm.member.business.member.sdk.enums.ApprovalStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.CpsYesOrNoEnum;
import com.biz.crm.member.business.member.sdk.vo.ActivityApplyRecordVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ActivityApplyRecordServiceImpl
implements ActivityApplyRecordService {
    @Autowired
    private ActivityApplyRecordRepository activityApplyRecordRepository;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ActivityManageRepository activityManageRepository;
    @Value(value="${crm.business.realorder.process-key:}")
    private String defaultProcessKey;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    public static final String MMS_ACTIVITY_MANAGE_CODE_REDIS_KEY = "mms:activity:manage:code:index:%s";
    public static final String MMS_ACTIVITY_MANAGE_CODE_PREFIX = "HD";

    @Override
    public ActivityApplyRecordVo create(ActivityApplyRecordDto activityApplyRecordDto) {
        return null;
    }

    @Override
    @Transactional
    public void join(ActivityApplyRecordDto dto) {
        String recordCode = this.baseValidate(dto);
        ActivityManage activity = (ActivityManage)((Object)((LambdaQueryChainWrapper)this.activityManageRepository.lambdaQuery().eq(ActivityManage::getCode, (Object)dto.getActivityCode())).one());
        Validate.isTrue((ObjectUtils.isNotEmpty((Object)((Object)activity)) && activity.getApplyEndDate().compareTo(new Date()) > 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7f16\u7801\u6216\u62a5\u540d\u65f6\u95f4\u4e0d\u6b63\u786e\uff01", (Object[])new Object[0]);
        boolean needApproval = activity.getNeedApproval().equals("1");
        boolean locked = false;
        try {
            ActivityManage act;
            if (!needApproval) {
                locked = this.redisMutexService.tryLock(dto.getActivityCode(), TimeUnit.SECONDS, 5);
                Validate.isTrue((boolean)locked, (String)"\u4e1a\u52a1\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002", (Object[])new Object[0]);
            }
            Validate.isTrue(((Integer)ObjectUtils.defaultIfNull((Object)(act = (ActivityManage)((Object)((LambdaQueryChainWrapper)this.activityManageRepository.lambdaQuery().eq(ActivityManage::getCode, (Object)dto.getActivityCode())).one())).getHasJoin(), (Object)0) < act.getApplyCeilingNum() ? 1 : 0) != 0, (String)"\u62b1\u6b49\uff0c\u62a5\u540d\u540d\u989d\u5df2\u7528\u5b8c\uff01", (Object[])new Object[0]);
            ActivityApplyRecord applyRecord = (ActivityApplyRecord)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, ActivityApplyRecord.class, HashSet.class, LinkedList.class, new String[0]));
            applyRecord.setTenantCode(TenantUtils.getTenantCode());
            applyRecord.setApplyDate(new Date());
            applyRecord.setRecordCode(recordCode);
            this.activityApplyRecordRepository.save((Object)applyRecord);
            dto.setId(applyRecord.getId());
            if (needApproval) {
                applyRecord.setProcessNumber(this.commitProcess(dto));
                applyRecord.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            } else {
                act.setHasJoin((Integer)ObjectUtils.defaultIfNull((Object)act.getHasJoin(), (Object)0) + 1);
                this.activityManageRepository.saveOrUpdate((Object)act);
                applyRecord.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
                applyRecord.setApprovalDate(new Date());
            }
            this.activityApplyRecordRepository.saveOrUpdate((Object)applyRecord);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(dto.getActivityCode());
            }
        }
    }

    @Override
    public String getId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public void sign(ActivityApplyRecordDto dto) {
        Validate.isTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{dto.getActivityCode(), dto.getUserName(), "\u7b7e\u5230\u65f6\uff0c\u6d3b\u52a8\u7f16\u7801\u4ee5\u53ca\u7528\u6237\u540d\u5747\u4e0d\u80fd\u4e3a\u7a7a\uff01"}));
        ActivityManage activity = (ActivityManage)((Object)((LambdaQueryChainWrapper)this.activityManageRepository.lambdaQuery().eq(ActivityManage::getCode, (Object)dto.getActivityCode())).one());
        Validate.isTrue((activity.getSignStartDate().compareTo(new Date()) < 0 && activity.getSignEndDate().compareTo(new Date()) > 0 ? 1 : 0) != 0, (String)"\u8bf7\u786e\u4fdd\u5f53\u524d\u65f6\u95f4\u5728\u7b7e\u5230\u65f6\u95f4\u8303\u56f4\u5185\uff01", (Object[])new Object[0]);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityApplyRecordRepository.lambdaUpdate().eq(ActivityApplyRecord::getActivityCode, (Object)dto.getActivityCode())).eq(ActivityApplyRecord::getUserName, (Object)dto.getUserName())).set(ActivityApplyRecord::getHasAttend, (Object)CpsYesOrNoEnum.YES.getValue())).set(ActivityApplyRecord::getMyAttendTime, (Object)new Date())).update();
    }

    @Override
    public ActivityApplyRecordVo updateForm(ActivityApplyRecordDto activityApplyRecordDto) {
        return null;
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityApplyRecordRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public ActivityApplyRecordVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ActivityApplyRecord activityApplyRecord = (ActivityApplyRecord)((Object)this.activityApplyRecordRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)activityApplyRecord), (String)"\u62a5\u540d\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        ActivityApplyRecordVo activityApplyRecordVo = (ActivityApplyRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityApplyRecord, ActivityApplyRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
        return activityApplyRecordVo;
    }

    @Override
    public Page<ActivityApplyRecordVo> findByConditions(Pageable pageable, ActivityApplyRecordDto activityApplyRecordDto) {
        if (Objects.isNull(activityApplyRecordDto)) {
            activityApplyRecordDto = new ActivityApplyRecordDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityApplyRecordRepository.findByConditions((Page<ActivityApplyRecordVo>)page, activityApplyRecordDto);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityApplyRecordRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityApplyRecordRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void approvalPass(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityApplyRecordRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)ApprovalStatusEnum.PASS.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void approvalReturn(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityApplyRecordRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)ApprovalStatusEnum.BACK.getCode())).in(UuidEntity::getId, ids)).update();
    }

    private String commitProcess(ActivityApplyRecordDto dto) {
        ProcessBusinessDto processBusiness = Optional.ofNullable(dto.getProcessBusiness()).orElse(new ProcessBusinessDto());
        String processKey = processBusiness.getProcessKey();
        if (StringUtils.isBlank((CharSequence)processKey)) {
            processBusiness.setProcessKey(this.defaultProcessKey);
        }
        processBusiness.setBusinessNo(dto.getId());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("APPLET_ACT_WORK_FLOW");
        processBusiness.setProcessTitle("\u6d3b\u52a8\u7f16\u7801" + dto.getActivityCode() + "\u7528\u6237\u540d" + dto.getUserName());
        this.processBusinessMappingService.deleteByBusinessNoAndBusinessCodeAndProcessKey(dto.getId(), "APPLET_ACT_WORK_FLOW", processBusiness.getProcessKey());
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        return processBusinessVo.getProcessNo();
    }

    private String baseValidate(ActivityApplyRecordDto recordDto) {
        Validate.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{recordDto.getApplyUserName(), recordDto.getSex(), recordDto.getHobby(), recordDto.getActivityCode()}), (String)"\u59d3\u540d\u3001\u6027\u522b\u3001\u7231\u597d\u3001\u6d3b\u52a8\u7f16\u7801\u5747\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)recordDto.getBirthday()), (String)"\u751f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        recordDto.setUserName(loginDetails.getAccount());
        List hasExist = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityApplyRecordRepository.lambdaQuery().eq(ActivityApplyRecord::getActivityCode, (Object)recordDto.getActivityCode())).eq(ActivityApplyRecord::getUserName, (Object)loginDetails.getAccount())).list();
        if (!"1".equals(recordDto.getOperateAgain())) {
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)hasExist), (String)"\u8bf7\u52ff\u91cd\u590d\u62a5\u540d\uff01", (Object[])new Object[0]);
        } else {
            Validate.isTrue((hasExist.size() == 1 && !ProcessStatusEnum.PASS.getDictCode().equals(((ActivityApplyRecord)((Object)hasExist.get(0))).getProcessStatus()) && !ProcessStatusEnum.COMMIT.getDictCode().equals(((ActivityApplyRecord)((Object)hasExist.get(0))).getProcessStatus()) ? 1 : 0) != 0, (String)"\u5b58\u5728\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u62a5\u540d\u8bb0\u5f55\uff0c\u8bf7\u52ff\u91cd\u590d\u62a5\u540d\uff01", (Object[])new Object[0]);
            ((LambdaUpdateChainWrapper)this.activityApplyRecordRepository.lambdaUpdate().eq(ActivityApplyRecord::getRecordCode, (Object)((ActivityApplyRecord)((Object)hasExist.get(0))).getRecordCode())).remove();
        }
        return (String)this.generateCodeService.generateCode("XCX-HDBM-", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
    }
}

