/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.ActivityApplyConfig;
import com.biz.crm.member.business.member.local.entity.ActivityManage;
import com.biz.crm.member.business.member.local.repository.ActivityApplyConfigRepository;
import com.biz.crm.member.business.member.local.repository.ActivityApplyRecordRepository;
import com.biz.crm.member.business.member.local.repository.ActivityManageRepository;
import com.biz.crm.member.business.member.local.service.ActivityManageService;
import com.biz.crm.member.business.member.sdk.dto.ActivityApplyConfigDto;
import com.biz.crm.member.business.member.sdk.dto.ActivityManageDto;
import com.biz.crm.member.business.member.sdk.dto.ActivityManagePageDto;
import com.biz.crm.member.business.member.sdk.enums.ActivityForUserEnum;
import com.biz.crm.member.business.member.sdk.enums.ActivityStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.CpsYesOrNoEnum;
import com.biz.crm.member.business.member.sdk.utils.QRBarCodeUtil;
import com.biz.crm.member.business.member.sdk.vo.ActivityApplyConfigVo;
import com.biz.crm.member.business.member.sdk.vo.ActivityManagePageVo;
import com.biz.crm.member.business.member.sdk.vo.ActivityManageVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityManageServiceImpl
implements ActivityManageService {
    @Autowired
    private ActivityManageRepository activityManageRepository;
    @Autowired
    private ActivityApplyConfigRepository activityApplyConfigRepository;
    @Autowired
    private ActivityApplyRecordRepository activityApplyRecordRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private LoginUserService loginUserService;
    public static final String MMS_ACTIVITY_MANAGE_CODE_REDIS_KEY = "mms:activity:manage:code:index:%s";
    public static final String MMS_ACTIVITY_MANAGE_CODE_PREFIX = "HD";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_ACTIVITY_MANAGE_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_ACTIVITY_MANAGE_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public Page<ActivityManagePageVo> findByConditions(Pageable pageable, ActivityManagePageDto activityManageDto) {
        if (Objects.isNull(activityManageDto)) {
            activityManageDto = new ActivityManagePageDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.getRecords().forEach(x -> {
            if (StringUtils.isEmpty((CharSequence)x.getAttendNum())) {
                x.setAttendNum("0");
            }
        });
        return this.activityManageRepository.findByConditions((Page<ActivityManagePageVo>)page, activityManageDto);
    }

    @Override
    public Page<ActivityManagePageVo> findByConditionsByApplet(Pageable pageable, ActivityManagePageDto dto) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getActivityStatus()), (String)"\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5b57\u5178\u7f16\u7801\u7c7b\u578bmms_activity_status", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String currentAccount = loginDetails.getAccount();
        dto.setUserName(currentAccount);
        Page<ActivityManagePageVo> activities = this.activityManageRepository.findByConditionsByApplet((Page<ActivityManagePageVo>)page, dto);
        List records = activities.getRecords();
        for (ActivityManagePageVo vo : records) {
            String activityStatus = vo.getActivityStatus();
            String processStatus = vo.getProcessStatus();
            if (activityStatus.equals(ActivityStatusEnum.APPLY_ING.getDes())) {
                if ((Integer)ObjectUtils.defaultIfNull((Object)vo.getHasJoin(), (Object)0) >= vo.getApplyCeilingNum() && !((String)ObjectUtils.defaultIfNull((Object)vo.getUserName(), (Object)"")).equals(currentAccount)) {
                    vo.setStatusForUser(ActivityForUserEnum.FULL_JOIN.getDes());
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)vo.getUserName()) || !((String)ObjectUtils.defaultIfNull((Object)vo.getUserName(), (Object)"")).equals(currentAccount)) {
                    vo.setStatusForUser(ActivityForUserEnum.JOIN_NOW.getDes());
                    continue;
                }
                if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)) {
                    vo.setActivityStatus("\u62a5\u540d\u88ab\u9a73\u56de");
                    vo.setStatusForUser(ActivityForUserEnum.JOIN_AGAIN.getDes());
                    continue;
                }
                vo.setStatusForUser(ActivityForUserEnum.HAS_JOIN.getDes());
                continue;
            }
            if (activityStatus.equals(ActivityStatusEnum.SIGN_ING.getDes())) {
                if (StringUtils.isEmpty((CharSequence)vo.getUserName()) || !((String)ObjectUtils.defaultIfNull((Object)vo.getUserName(), (Object)"")).equals(currentAccount)) {
                    vo.setStatusForUser(ActivityForUserEnum.NO_JOIN.getDes());
                    continue;
                }
                if (ActivityStatusEnum.WAIT_SIGN.getDes().equals(activityStatus)) {
                    vo.setStatusForUser(ActivityForUserEnum.WAIT_SIGN.getDes());
                    continue;
                }
                if ("1".equals(vo.getHasAttend())) {
                    vo.setStatusForUser(ActivityForUserEnum.HAS_SIGN.getDes());
                    continue;
                }
                if (!ActivityStatusEnum.SIGN_ING.getDes().equals(activityStatus)) continue;
                vo.setStatusForUser(ActivityForUserEnum.SCANNING_SIGN.getDes());
                continue;
            }
            if (!activityStatus.equals(ActivityStatusEnum.END.getDes())) continue;
            if (CpsYesOrNoEnum.YES.getValue().equals(vo.getHasAttend())) {
                vo.setStatusForUser(ActivityForUserEnum.COMPLETE.getDes());
                continue;
            }
            if (ProcessStatusEnum.PASS.getDictCode().equals(vo.getProcessStatus()) && !CpsYesOrNoEnum.YES.getValue().equals(vo.getHasAttend())) {
                vo.setStatusForUser(ActivityForUserEnum.NO_SIGN.getDes());
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)vo.getUserName())) continue;
            vo.setStatusForUser(ActivityForUserEnum.NO_JOIN.getDes());
        }
        return activities;
    }

    @Override
    public ActivityManageVo findDetailById(String id, String fromPhone) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String currentAccount = loginDetails.getAccount();
        ActivityManagePageDto dto = new ActivityManagePageDto();
        dto.setId(id);
        dto.setUserName(currentAccount);
        dto.setFromPhone(fromPhone);
        ActivityManage act = this.activityManageRepository.getActById(dto);
        Validate.notNull((Object)((Object)act), (String)"\u6d3b\u52a8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if ("1".equals(fromPhone)) {
            String actStatus = act.getActivityStatus();
            String processStatus = act.getProcessStatus();
            if (ActivityStatusEnum.NOT_START.getDes().equals(actStatus)) {
                act.setStatusForUser(ActivityForUserEnum.NO_START.getDes());
            }
            if (ActivityStatusEnum.END.getDes().equals(actStatus)) {
                act.setStatusForUser(ActivityForUserEnum.THE_END.getDes());
            } else if ((Integer)ObjectUtils.defaultIfNull((Object)act.getHasJoin(), (Object)0) >= act.getApplyCeilingNum() && StringUtils.isEmpty((CharSequence)act.getProcessStatus())) {
                act.setStatusForUser(ActivityForUserEnum.FULL_JOIN.getDes());
            } else if (ActivityStatusEnum.APPLY_ING.getDes().equals(actStatus) && StringUtils.isEmpty((CharSequence)processStatus)) {
                act.setStatusForUser(ActivityForUserEnum.JOIN_NOW.getDes());
            } else if (ProcessStatusEnum.COMMIT.getDictCode().equals(processStatus)) {
                act.setStatusForUser(ActivityForUserEnum.COMMITTING.getDes());
            } else if ((ActivityStatusEnum.WAIT_SIGN.getDes().equals(actStatus) || ActivityStatusEnum.APPLY_ING.getDes().equals(actStatus)) && ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
                act.setStatusForUser(ActivityForUserEnum.WAIT_SIGN.getDes());
            } else if (CpsYesOrNoEnum.YES.getValue().equals(act.getHasAttend())) {
                act.setStatusForUser(ActivityForUserEnum.HAS_SIGN.getDes());
            } else if (ActivityStatusEnum.SIGN_ING.getDes().equals(actStatus) && ProcessStatusEnum.PASS.getDictCode().equals(processStatus) && !CpsYesOrNoEnum.YES.getValue().equals(act.getHasAttend())) {
                act.setStatusForUser(ActivityForUserEnum.SCANNING_SIGN.getDes());
            } else if (StringUtils.isNotEmpty((CharSequence)processStatus) && !ProcessStatusEnum.PASS.getDictCode().equals(processStatus) && !ProcessStatusEnum.COMMIT.getDictCode().equals(processStatus)) {
                act.setStatusForUser(ActivityForUserEnum.JOIN_AGAIN.getDes());
            } else if ((ActivityStatusEnum.WAIT_SIGN.getDes().equals(actStatus) || ActivityStatusEnum.SIGN_ING.getDes().equals(actStatus)) && StringUtils.isEmpty((CharSequence)processStatus)) {
                act.setStatusForUser(ActivityForUserEnum.MISS.getDes());
            }
        }
        ActivityManageVo activityManageVo = (ActivityManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)act, ActivityManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityApplyConfigRepository.lambdaQuery().eq(ActivityApplyConfig::getActivityCode, (Object)act.getCode())).orderByAsc(ActivityApplyConfig::getSortIndex)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            activityManageVo.setActivityApplyConfigVo((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityApplyConfig.class, ActivityApplyConfigVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        if (!"1".equals(fromPhone)) {
            this.currentActivityStatus(activityManageVo);
        }
        return activityManageVo;
    }

    public void currentActivityStatus(ActivityManageVo activityManageVo) {
        Date now = new Date();
        Date applyStartDate = activityManageVo.getApplyStartDate();
        Date applyEndDate = activityManageVo.getApplyEndDate();
        Date signStartDate = activityManageVo.getSignStartDate();
        Date signEndDate = activityManageVo.getSignEndDate();
        boolean before = now.before(applyStartDate);
        boolean after = now.after(signEndDate);
        boolean applyIn = DateUtil.isIn((Date)now, (Date)applyStartDate, (Date)applyEndDate);
        boolean signIn = DateUtil.isIn((Date)now, (Date)signStartDate, (Date)signEndDate);
        boolean wait = DateUtil.isIn((Date)now, (Date)applyEndDate, (Date)signStartDate);
        String activityStatus = null;
        activityStatus = after ? ActivityStatusEnum.END.getCode() : (signIn ? ActivityStatusEnum.SIGN_ING.getCode() : (wait ? ActivityStatusEnum.WAIT_SIGN.getCode() : (applyIn ? ActivityStatusEnum.APPLY_ING.getCode() : ActivityStatusEnum.NOT_START.getCode())));
        activityManageVo.setActivityStatus(activityStatus);
    }

    @Override
    @Transactional
    public ActivityManageVo create(ActivityManageDto activityManageDto) {
        this.createValidate(activityManageDto);
        activityManageDto.setTenantCode(TenantUtils.getTenantCode());
        activityManageDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        activityManageDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activityManageDto.setCode(this.generateCode(TenantUtils.getTenantCode()));
        ActivityManage activityManage = (ActivityManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityManageDto, ActivityManage.class, HashSet.class, LinkedList.class, new String[0]));
        activityManage.setFileId(activityManageDto.getFileId());
        this.activityManageRepository.saveOrUpdate((Object)activityManage);
        if (CollectionUtils.isNotEmpty((Collection)activityManageDto.getActivityApplyConfigDto())) {
            for (ActivityApplyConfigDto activityApplyConfigDto : activityManageDto.getActivityApplyConfigDto()) {
                ActivityApplyConfig activityApplyConfig = (ActivityApplyConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityApplyConfigDto, ActivityApplyConfig.class, HashSet.class, LinkedList.class, new String[0]));
                activityApplyConfig.setActivityCode(activityManage.getCode());
                activityApplyConfig.setTenantCode(TenantUtils.getTenantCode());
                activityApplyConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                activityApplyConfig.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                this.activityApplyConfigRepository.saveOrUpdate((Object)activityApplyConfig);
            }
        }
        return (ActivityManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityManage, ActivityManageVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void createValidate(ActivityManageDto activityManageDto) {
        Validate.notNull((Object)activityManageDto, (String)"\u65b0\u589e\u53c2\u6570\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getSignEndDate(), (String)"\u7b7e\u7ea6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getSignStartDate(), (String)"\u7b7e\u7ea6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getApplyStartDate(), (String)"\u62a5\u540d\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getApplyEndDate(), (String)"\u62a5\u540d\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getApplyCeilingNum(), (String)"\u62a5\u540d\u4eba\u6570\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getName(), (String)"\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getAddress(), (String)"\u6d3b\u52a8\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getActivityDsc(), (String)"\u6d3b\u52a8\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getNeedApproval(), (String)"\u62a5\u540d\u5ba1\u6279\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getApplyRequire(), (String)"\u7b49\u7ea7\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((activityManageDto.getSignStartDate().compareTo(activityManageDto.getApplyEndDate()) >= 0 ? 1 : 0) != 0, (String)"\u7b7e\u5230\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u62a5\u540d\u622a\u6b62\u65f6\u95f4\uff01", (Object[])new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)activityManageDto.getActivityApplyConfigDto())) {
            for (ActivityApplyConfigDto applyConfigDto : activityManageDto.getActivityApplyConfigDto()) {
                Validate.notNull((Object)applyConfigDto.getTitle(), (String)"\u6807\u5934\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)applyConfigDto.getField(), (String)"\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        if (activityManageDto.getSignStartDate().before(activityManageDto.getApplyEndDate())) {
            throw new RuntimeException("\u7b7e\u5230\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u62a5\u540d\u7ed3\u675f\u65f6\u95f4");
        }
    }

    @Override
    @Transactional
    public ActivityManageVo updateForm(ActivityManageDto activityManageDto) {
        this.updateValidate(activityManageDto);
        ActivityManageVo activityManageVo = this.findDetailById(activityManageDto.getId(), null);
        Validate.notNull((Object)activityManageVo, (String)"\u6d3b\u52a8\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        activityManageDto.setTenantCode(TenantUtils.getTenantCode());
        switch (ActivityStatusEnum.codeToEnum((String)activityManageVo.getActivityStatus())) {
            case APPLY_ING: 
            case WAIT_SIGN: {
                this.updateBaseInfo(activityManageDto);
            }
            case SIGN_ING: {
                this.validateSignIng(activityManageDto, activityManageVo);
                this.updateBaseInfo(activityManageDto);
                break;
            }
            case NOT_START: {
                this.update(activityManageDto);
                break;
            }
        }
        return null;
    }

    private ActivityManageVo update(ActivityManageDto activityManageDto) {
        ActivityManageVo activityManageVo = this.updateBaseInfo(activityManageDto);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"activity_code", (Object)activityManageDto.getCode());
        this.activityApplyConfigRepository.remove((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)activityManageDto.getActivityApplyConfigDto())) {
            for (ActivityApplyConfigDto activityApplyConfigDto : activityManageDto.getActivityApplyConfigDto()) {
                ActivityApplyConfig activityApplyConfig = (ActivityApplyConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityApplyConfigDto, ActivityApplyConfig.class, HashSet.class, LinkedList.class, new String[0]));
                activityApplyConfig.setId(null);
                activityApplyConfig.setActivityCode(activityManageDto.getCode());
                activityApplyConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                activityApplyConfig.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityApplyConfig.setTenantCode(TenantUtils.getTenantCode());
                this.activityApplyConfigRepository.saveOrUpdate((Object)activityApplyConfig);
            }
        }
        return activityManageVo;
    }

    private void validateSignIng(ActivityManageDto activityManageDto, ActivityManageVo activityManageVo) {
        int compare = DateUtil.compare((Date)activityManageDto.getApplyEndDate(), (Date)activityManageVo.getApplyEndDate());
        Validate.isTrue((compare == 0 ? 1 : 0) != 0, (String)"\u7b7e\u5230\u4e2d,\u4e0d\u80fd\u7f16\u8f91\u62a5\u540d\u65f6\u95f4", (Object[])new Object[0]);
        int compare1 = DateUtil.compare((Date)activityManageDto.getApplyStartDate(), (Date)activityManageVo.getApplyStartDate());
        Validate.isTrue((compare1 == 0 ? 1 : 0) != 0, (String)"\u7b7e\u5230\u4e2d,\u4e0d\u80fd\u7f16\u8f91\u62a5\u540d\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((boolean)StrUtil.equals((CharSequence)activityManageDto.getNeedApproval(), (CharSequence)activityManageVo.getNeedApproval()), (String)"\u7b7e\u5230\u4e2d,\u4e0d\u80fd\u7f16\u8f91\u662f\u5426\u5ba1\u6279", (Object[])new Object[0]);
        Validate.isTrue((boolean)StrUtil.equals((CharSequence)activityManageDto.getNeedApproval(), (CharSequence)activityManageVo.getNeedApproval()), (String)"\u7b7e\u5230\u4e2d,\u4e0d\u80fd\u7f16\u8f91\u662f\u5426\u5ba1\u6279", (Object[])new Object[0]);
        Validate.isTrue((activityManageDto.getApplyCeilingNum() == activityManageVo.getApplyCeilingNum() ? 1 : 0) != 0, (String)"\u7b7e\u5230\u4e2d,\u4e0d\u80fd\u7f16\u8f91\u62a5\u540d\u4eba\u6570\u4e0a\u9650", (Object[])new Object[0]);
    }

    private ActivityManageVo updateBaseInfo(ActivityManageDto activityManageDto) {
        ActivityManage activityManage = (ActivityManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityManageDto, ActivityManage.class, HashSet.class, LinkedList.class, new String[0]));
        this.activityManageRepository.saveOrUpdate((Object)activityManage);
        return (ActivityManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityManage, ActivityManageVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    private void updateValidate(ActivityManageDto activityManageDto) {
        Validate.notNull((Object)activityManageDto, (String)"\u7f16\u8f91\u53c2\u6570\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getSignEndDate(), (String)"\u7b7e\u7ea6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getSignStartDate(), (String)"\u7b7e\u7ea6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getApplyStartDate(), (String)"\u62a5\u540d\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getApplyEndDate(), (String)"\u62a5\u540d\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)activityManageDto.getApplyCeilingNum(), (String)"\u62a5\u540d\u4eba\u6570\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getName(), (String)"\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getAddress(), (String)"\u6d3b\u52a8\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getActivityDsc(), (String)"\u6d3b\u52a8\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getNeedApproval(), (String)"\u62a5\u540d\u5ba1\u6279\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getApplyRequire(), (String)"\u7b49\u7ea7\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityManageDto.getCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (activityManageDto.getSignStartDate().before(activityManageDto.getApplyEndDate())) {
            throw new RuntimeException("\u7b7e\u5230\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u62a5\u540d\u7ed3\u675f\u65f6\u95f4");
        }
        if (CollectionUtils.isNotEmpty((Collection)activityManageDto.getActivityApplyConfigDto())) {
            for (ActivityApplyConfigDto activityApplyConfigDto : activityManageDto.getActivityApplyConfigDto()) {
                Validate.notNull((Object)activityApplyConfigDto.getTitle(), (String)"\u6807\u5934\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)activityApplyConfigDto.getField(), (String)"\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityManageRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityManageRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityManageRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void buildBarCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        QRBarCodeUtil.createCodeToFile((String)code, null, (String)("\u6d3b\u52a8\u4e8c\u7ef4\u7801" + code));
    }

    @Override
    public ActivityManageVo getOneByEnableOrderBySignEndTime() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByDesc(ActivityManage::getSignEndDate)).last("limit 1");
        ActivityManage activityManage = (ActivityManage)((Object)this.activityManageRepository.getOne((Wrapper)queryWrapper));
        ActivityManageVo result = (ActivityManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityManage, ActivityManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }
}

