/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.AddressManage;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.AddressManageRepository;
import com.biz.crm.member.business.member.local.service.AddressManageService;
import com.biz.crm.member.business.member.sdk.dto.AddressManagePaginationDto;
import com.biz.crm.member.business.member.sdk.vo.AddressManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="addressManageServiceImpl")
public class AddressManageServiceImpl
implements AddressManageService {
    private static final Logger log = LoggerFactory.getLogger(AddressManageServiceImpl.class);
    @Autowired
    private AddressManageRepository addressManageRepository;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<AddressManageVo> findByConditions(Pageable pageable, AddressManagePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AddressManagePaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isBlank((CharSequence)dto.getMemberCode())) {
            String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
            dto.setMemberCode(memberCode);
        }
        return this.addressManageRepository.findByConditions((Page<AddressManageVo>)page, dto);
    }

    @Override
    public AddressManageVo create(AddressManageVo addressManageVo) {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        AddressManage addressManage = (AddressManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)addressManageVo, AddressManage.class, HashSet.class, LinkedList.class, new String[0]));
        addressManage.setTenantCode(TenantUtils.getTenantCode());
        addressManage.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        addressManage.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)addressManageVo.getMemberCode())) {
            addressManage.setMemberCode(memberCode);
        }
        this.createValidation(addressManageVo);
        this.addressManageRepository.saveOrUpdate((Object)addressManage);
        if ("1".equals(addressManageVo.getFlagDefaultAddress())) {
            this.setDefault(addressManage.getId());
        }
        return addressManageVo;
    }

    @Override
    @Transactional
    public AddressManageVo update(AddressManageVo addressManageVo) {
        this.updateValidation(addressManageVo);
        String currentId = addressManageVo.getId();
        AddressManage current = (AddressManage)((Object)((LambdaQueryChainWrapper)this.addressManageRepository.lambdaQuery().eq(UuidEntity::getId, (Object)currentId)).one());
        current = (AddressManage)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (AddressManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)addressManageVo, AddressManage.class, HashSet.class, LinkedList.class, new String[0]));
        this.addressManageRepository.saveOrUpdate((Object)current);
        if ("1".equals(addressManageVo.getFlagDefaultAddress())) {
            this.setDefault(current.getId());
        }
        return addressManageVo;
    }

    @Override
    public AddressManageVo findDetailById(String id) {
        Validate.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AddressManage addressManage = (AddressManage)((Object)((LambdaQueryChainWrapper)this.addressManageRepository.lambdaQuery().eq(UuidEntity::getId, (Object)id)).one());
        AddressManageVo addressManageVo = (AddressManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)addressManage, AddressManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        Validate.notNull((Object)addressManageVo, (String)"\u5730\u5740\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return addressManageVo;
    }

    @Override
    @Transactional
    public void setDefault(String id) {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.addressManageRepository.lambdaUpdate().eq(AddressManage::getMemberCode, (Object)memberCode)).set(AddressManage::getFlagDefaultAddress, (Object)"0")).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.addressManageRepository.lambdaUpdate().eq(UuidEntity::getId, (Object)id)).set(AddressManage::getFlagDefaultAddress, (Object)"1")).update();
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.addressManageRepository.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    @Override
    public void updateDelFlagById(String id) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.addressManageRepository.lambdaUpdate().eq(UuidEntity::getId, (Object)id)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    private void createValidation(AddressManageVo addressManageVo) {
        this.validation(addressManageVo);
    }

    private void updateValidation(AddressManageVo addressManageVo) {
        this.validation(addressManageVo);
    }

    private void validation(AddressManageVo addressManageVo) {
        Validate.notBlank((CharSequence)addressManageVo.getMemberPhone(), (String)"\u4f1a\u5458\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)addressManageVo.getMemberName(), (String)"\u4f1a\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)addressManageVo.getProvinceName(), (String)"\u7701\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)addressManageVo.getProvinceCode(), (String)"\u7701\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)addressManageVo.getCityName(), (String)"\u5e02\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)addressManageVo.getCityCode(), (String)"\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)addressManageVo.getDistrictName(), (String)"\u533a\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)addressManageVo.getDistrictCode(), (String)"\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)addressManageVo.getDetailAddress(), (String)"\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

