/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.member.business.member.local.entity.AnswerRecord;
import com.biz.crm.member.business.member.local.repository.AnswerRecordRepository;
import com.biz.crm.member.business.member.local.repository.AnswerUserRepository;
import com.biz.crm.member.business.member.local.repository.QuestionnaireQuestionRepository;
import com.biz.crm.member.business.member.local.service.AnswerRecordService;
import com.biz.crm.member.business.member.sdk.dto.AnswerRecordPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.AnswerRecordVo;
import com.biz.crm.member.business.member.sdk.vo.QuestionStatisticVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AnswerRecordServiceImpl
implements AnswerRecordService {
    @Autowired
    private AnswerRecordRepository answerRecordRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AnswerUserRepository answerUserRepository;
    @Autowired
    private QuestionnaireQuestionRepository questionnaireQuestionRepository;

    @Override
    public List<QuestionStatisticVo> statisticQuestion(List<String> questionCodes) {
        if (CollectionUtils.isEmpty(questionCodes)) {
            return Collections.EMPTY_LIST;
        }
        return this.answerRecordRepository.statisticQuestion(questionCodes);
    }

    @Override
    public Page<AnswerRecordVo> pageAnswerRecord(Pageable pageable, AnswerRecordPaginationDto dto) {
        Validate.notBlank((CharSequence)dto.getQuestionCode(), (String)"\u9898\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AnswerRecordPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AnswerRecordVo> result = this.answerRecordRepository.pageAnswerRecord((Page<AnswerRecordVo>)page, dto);
        return result;
    }

    @Override
    public List<AnswerRecordVo> getByQuestionCodes(List<String> questionCodes, String memberCode) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(questionCodes), (String)"\u9898\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)memberCode, (String)"\u76ee\u6807\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(AnswerRecord::getMemberCode, (Object)memberCode)).in(AnswerRecord::getQuestionCode, questionCodes);
        List answerRecords = this.answerRecordRepository.list((Wrapper)queryWrapper);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)answerRecords, AnswerRecord.class, AnswerRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }

    @Override
    public List<AnswerRecord> listAnswerRecord(List<String> questionCodes) {
        if (CollectionUtils.isEmpty(questionCodes)) {
            return Collections.EMPTY_LIST;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(AnswerRecord::getQuestionCode, questionCodes);
        List result = this.answerRecordRepository.list((Wrapper)queryWrapper);
        return result;
    }

    @Override
    @Transactional
    public void batchSave(List<AnswerRecord> answerRecords) {
        this.answerRecordRepository.saveBatch(answerRecords);
    }
}

