/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.AppPointExchangeEntity;
import com.biz.crm.member.business.member.local.entity.ProductExchangeRule;
import com.biz.crm.member.business.member.local.entity.ProductFile;
import com.biz.crm.member.business.member.local.repository.ActivityManageRepository;
import com.biz.crm.member.business.member.local.repository.ProductExchangeRuleRepository;
import com.biz.crm.member.business.member.local.repository.ProductFileRepository;
import com.biz.crm.member.business.member.local.repository.ProductRepository;
import com.biz.crm.member.business.member.local.service.AppPointStoreService;
import com.biz.crm.member.business.member.local.service.LevelManageService;
import com.biz.crm.member.business.member.sdk.dto.AppPointStoreDto;
import com.biz.crm.member.business.member.sdk.dto.AppPointStorePeopleDto;
import com.biz.crm.member.business.member.sdk.dto.ProductPageDto;
import com.biz.crm.member.business.member.sdk.enums.ProductTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.ProductFileVo;
import com.biz.crm.member.business.member.sdk.vo.ProductPageVo;
import com.biz.crm.member.business.member.sdk.vo.ProductVo;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletLevelManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AppPointStoreServiceImpl
implements AppPointStoreService {
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    ActivityManageRepository activityManageRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ProductFileRepository productFileRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LevelManageService levelManageService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ProductExchangeRuleRepository productExchangeRuleRepository;

    @Override
    public Page<ProductPageVo> findByConditions(Pageable pageable, ProductPageDto pageDto) {
        if (Objects.isNull(pageDto)) {
            pageDto = new ProductPageDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        pageDto.setUserName(loginDetails.getAccount());
        if ("1".equals(pageDto.getAvailable())) {
            Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)pageDto.getLevelCode()), (String)"\u67e5\u8be2\u53ef\u5151\u5546\u54c1\u65f6\uff0c\u5f53\u524d\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List<AppletLevelManageVo> childrenIncludeMe = this.levelManageService.getAllChildrenIncludeMe(pageDto.getLevelCode());
            pageDto.setBelowMemberCodes(childrenIncludeMe.stream().map(AppletLevelManageVo::getLevelCode).collect(Collectors.toList()));
        }
        Page<ProductPageVo> voPage = this.productRepository.findByConditionsByApplet((Page<ProductPageVo>)page, pageDto);
        List products = voPage.getRecords();
        List productFiles = ((LambdaQueryChainWrapper)this.productFileRepository.lambdaQuery().in(ProductFile::getShelfCode, (Collection)products.stream().map(ProductPageVo::getCode).collect(Collectors.toList()))).list();
        List productFileVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)productFiles, ProductFile.class, ProductFileVo.class, HashSet.class, LinkedList.class, new String[0]);
        Map shelfCodeToFileVo = productFileVos.stream().filter(x -> "3".equals(x.getType())).collect(Collectors.toMap(ProductFileVo::getShelfCode, Function.identity()));
        products.forEach(y -> y.setSmallFile((ProductFileVo)shelfCodeToFileVo.get(y.getCode())));
        return voPage;
    }

    @Override
    public ProductVo findDetailById(String id) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)"id\u5f02\u5e38\uff01", (Object[])new Object[0]);
        ProductVo productVo = this.productRepository.findAppletDetailById(id);
        if (ProductTypeEnum.VIRTUAL.getCode().equals(productVo.getProductType())) {
            productVo.setValidateUse("\u5151\u6362\u540e\u8bf7\u5728" + productVo.getValidateUse() + "\u5929\u5185\u4f7f\u7528\uff0c\u903e\u671f\u89c6\u4f5c\u653e\u5f03\u6743\u76ca\uff01");
        } else {
            productVo.setValidateUse(null);
        }
        return productVo;
    }

    @Override
    @Transactional
    public void exchangeVirtual(AppPointStoreDto dto) {
        List<String> orderCode = this.exchangeValidate(dto);
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(dto.getCode(), TimeUnit.SECONDS, 5);
            ProductExchangeRule exchangeRule = (ProductExchangeRule)((Object)((LambdaQueryChainWrapper)this.productExchangeRuleRepository.lambdaQuery().eq(ProductExchangeRule::getShelfCode, (Object)dto.getCode())).one());
            Validate.isTrue((exchangeRule.getInventoryQuantity().compareTo(new BigDecimal(dto.getExchangeCount())) >= 0 ? 1 : 0) != 0, (String)"\u8be5\u79ef\u5206\u5546\u54c1\u5df2\u88ab\u5151\u5b8c\uff01", (Object[])new Object[0]);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(dto.getCode());
            }
        }
    }

    private List<String> exchangeValidate(AppPointStoreDto dto) {
        Validate.isTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{dto.getProductCode(), dto.getCode(), dto.getExchangeCount(), dto.getProductType(), "\u5546\u54c1\u7f16\u7801\u3001\u5546\u54c1\u7c7b\u578b(1\u5b9e\u72692\u865a\u62df)\u3001\u4e0a\u67b6\u7f16\u7801\u3001\u5151\u6362\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01"}));
        Validate.isTrue((boolean)ProductTypeEnum.VIRTUAL.getCode().equals(dto.getProductType()), (String)"\u5151\u6362\u5546\u54c1\u7c7b\u578b\u5f02\u5e38\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getContacts().size() >= 1 ? 1 : 0) != 0, (String)"\u7f3a\u5931\u5151\u6362\u4eba\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getContacts().size() == Integer.parseInt(dto.getExchangeCount()) ? 1 : 0) != 0, (String)"\u5151\u6362\u7269\u54c1\u6570\u91cf\u4e0e\u8054\u7cfb\u4eba\u7684\u6570\u91cf\u9700\u4fdd\u6301\u4e00\u81f4\uff01", (Object[])new Object[0]);
        Map<String, List<AppPointStorePeopleDto>> groupByPhone = dto.getContacts().stream().collect(Collectors.groupingBy(AppPointStorePeopleDto::getContactPhone));
        for (String key : groupByPhone.keySet()) {
            List<AppPointStorePeopleDto> contact = groupByPhone.get(key);
            contact.forEach(x -> Validate.isTrue((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{x.getContactName(), x.getContactName()}), (String)"\u8054\u7cfb\u4eba\u59d3\u540d\u4e0e\u7535\u8bdd\u5747\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
            Validate.isTrue((groupByPhone.get(key).size() == 1 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\u7684\u7535\u8bdd\u4e0d\u80fd\u91cd\u590d!", (Object[])new Object[0]);
        }
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
        AppPointExchangeEntity ruleVo = this.productRepository.findAvailableCount(dto);
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)((Object)ruleVo)), (String)"\u5546\u54c1\u4e0a\u67b6\u4fe1\u606f\u5f02\u5e38\uff01", (Object[])new Object[0]);
        String message = "\u8d85\u8fc7\u5151\u6362\u6b21\u6570\u9650\u5236\uff01";
        if ("\u6bcf\u65e5".equals(ruleVo.getExchangePeriodName())) {
            Validate.isTrue((ruleVo.getQuantity() - (Integer)ObjectUtils.defaultIfNull((Object)ruleVo.getCurrentDay(), (Object)0) >= 0 ? 1 : 0) != 0, (String)message, (Object[])new Object[0]);
        } else if ("\u6bcf\u6708".equals(ruleVo.getExchangePeriodName())) {
            Validate.isTrue((ruleVo.getQuantity() - (Integer)ObjectUtils.defaultIfNull((Object)ruleVo.getCurrentMonth(), (Object)0) >= 0 ? 1 : 0) != 0, (String)message, (Object[])new Object[0]);
        } else if ("\u6bcf\u5e74".equals(ruleVo.getExchangePeriodName())) {
            Validate.isTrue((ruleVo.getQuantity() - (Integer)ObjectUtils.defaultIfNull((Object)ruleVo.getCurrentYear(), (Object)0) >= 0 ? 1 : 0) != 0, (String)message, (Object[])new Object[0]);
        } else if ("\u6bcf\u4e2a\u7528\u6237".equals(ruleVo.getExchangePeriodName())) {
            Validate.isTrue((ruleVo.getQuantity() - (Integer)ObjectUtils.defaultIfNull((Object)ruleVo.getAccountExchange(), (Object)0) >= 0 ? 1 : 0) != 0, (String)message, (Object[])new Object[0]);
        }
        return this.generateCodeService.generateCode("POINT-XN-", dto.getContacts().size(), Integer.valueOf(4), 2L, TimeUnit.DAYS);
    }
}

