/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.local.repository.BenefitsManageOrgRepository;
import com.biz.crm.member.business.member.local.service.BenefitsManageOrgService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManageOrgPaginationDto;
import com.biz.crm.member.business.member.sdk.event.BenefitsManageOrgEventListener;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="benefitsManageOrgService")
public class BenefitsManageOrgServiceImpl
implements BenefitsManageOrgService {
    private static final Logger log = LoggerFactory.getLogger(BenefitsManageOrgServiceImpl.class);
    @Autowired(required=false)
    private BenefitsManageOrgRepository benefitsManageOrgRepository;
    @Autowired(required=false)
    private List<BenefitsManageOrgEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<BenefitsManageOrgVo> findByConditions(Pageable pageable, BenefitsManageOrgPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new BenefitsManageOrgPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.benefitsManageOrgRepository.findByConditions((Page<BenefitsManageOrgVo>)page, dto);
    }

    @Override
    public BenefitsManageOrgVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        BenefitsManageOrg benefitsManageOrg = this.benefitsManageOrgRepository.findById(id);
        BenefitsManageOrgVo benefitsManageOrgVo = (BenefitsManageOrgVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)benefitsManageOrg, BenefitsManageOrgVo.class, HashSet.class, LinkedList.class, new String[0]);
        return benefitsManageOrgVo;
    }

    @Override
    @Transactional
    public BenefitsManageOrgVo create(BenefitsManageOrgVo benefitsManageOrgVo) {
        this.createValidation(benefitsManageOrgVo);
        BenefitsManageOrg benefitsManageOrg = (BenefitsManageOrg)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)benefitsManageOrgVo, BenefitsManageOrg.class, HashSet.class, LinkedList.class, new String[0]));
        benefitsManageOrg.setTenantCode(TenantUtils.getTenantCode());
        benefitsManageOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        benefitsManageOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.benefitsManageOrgRepository.saveOrUpdate((Object)benefitsManageOrg);
        return benefitsManageOrgVo;
    }

    @Override
    @Transactional
    public BenefitsManageOrgVo update(BenefitsManageOrgVo benefitsManageOrgVo) {
        this.updateValidation(benefitsManageOrgVo);
        String currentId = benefitsManageOrgVo.getId();
        BenefitsManageOrg current = this.benefitsManageOrgRepository.findById(currentId);
        current = (BenefitsManageOrg)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (BenefitsManageOrg)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)benefitsManageOrgVo, BenefitsManageOrg.class, HashSet.class, LinkedList.class, new String[0]));
        this.benefitsManageOrgRepository.saveOrUpdate((Object)current);
        return benefitsManageOrgVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.benefitsManageOrgRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.benefitsManageOrgRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.benefitsManageOrgRepository.updateDelFlagByIds(ids);
    }

    @Override
    @Transactional
    public void saveBatch(List<BenefitsManageOrgVo> list) {
        ArrayList saveList = Lists.newArrayList();
        for (BenefitsManageOrgVo benefitsManageOrgVo : list) {
            this.createValidation(benefitsManageOrgVo);
            BenefitsManageOrg benefitsManageOrg = (BenefitsManageOrg)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)benefitsManageOrgVo, BenefitsManageOrg.class, HashSet.class, LinkedList.class, new String[0]));
            benefitsManageOrg.setTenantCode(TenantUtils.getTenantCode());
            benefitsManageOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            benefitsManageOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            saveList.add(benefitsManageOrg);
        }
        this.benefitsManageOrgRepository.saveBatch(saveList);
    }

    @Override
    public List<BenefitsManageOrg> findListByBenefitsManageId(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u6743\u76ca\u7ba1\u7406ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return ((LambdaQueryChainWrapper)this.benefitsManageOrgRepository.lambdaQuery().eq(BenefitsManageOrg::getBenefitsManageId, (Object)id)).list();
    }

    @Override
    public List<BenefitsManageOrgVo> findListVoByBenefitsManageId(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u6743\u76ca\u7ba1\u7406ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(this.findListByBenefitsManageId(id), BenefitsManageOrg.class, BenefitsManageOrgVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(BenefitsManageOrgVo benefitsManageOrgVo) {
        this.validation(benefitsManageOrgVo);
    }

    private void updateValidation(BenefitsManageOrgVo benefitsManageOrgVo) {
        this.validation(benefitsManageOrgVo);
    }

    private void validation(BenefitsManageOrgVo benefitsManageOrgVo) {
        Validate.notBlank((CharSequence)benefitsManageOrgVo.getBenefitsManageId(), (String)"\u6743\u76ca\u7ba1\u7406ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)benefitsManageOrgVo.getBenefitsManageCode(), (String)"\u6743\u76ca\u7ba1\u7406\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)benefitsManageOrgVo.getOrgCode(), (String)"\u533a\u57df\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)benefitsManageOrgVo.getOrgName(), (String)"\u533a\u57df\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)benefitsManageOrgVo.getExchangeValidPeriod(), (String)"\u5151\u6362\u6709\u6548\u671f(\u6708)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)benefitsManageOrgVo.getUseValidPeriod(), (String)"\u4f7f\u7528\u6709\u6548\u671f(\u5929)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

