/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.BenefitsManage;
import com.biz.crm.member.business.member.local.entity.BenefitsManageOrg;
import com.biz.crm.member.business.member.local.repository.BenefitsManageRepository;
import com.biz.crm.member.business.member.local.service.BenefitsManageOrgService;
import com.biz.crm.member.business.member.local.service.BenefitsManageService;
import com.biz.crm.member.business.member.sdk.dto.BenefitsManagePaginationDto;
import com.biz.crm.member.business.member.sdk.event.BenefitsManageEventListener;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageOrgVo;
import com.biz.crm.member.business.member.sdk.vo.BenefitsManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="benefitsManageService")
public class BenefitsManageServiceImpl
implements BenefitsManageService {
    private static final Logger log = LoggerFactory.getLogger(BenefitsManageServiceImpl.class);
    @Autowired(required=false)
    private BenefitsManageRepository benefitsManageRepository;
    @Autowired(required=false)
    private BenefitsManageOrgService benefitsManageOrgService;
    @Autowired(required=false)
    private List<BenefitsManageEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<BenefitsManageVo> findByConditions(Pageable pageable, BenefitsManagePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new BenefitsManagePaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.benefitsManageRepository.findByConditions((Page<BenefitsManageVo>)page, dto);
    }

    @Override
    public BenefitsManageVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        BenefitsManage benefitsManage = this.benefitsManageRepository.findById(id);
        Validate.notNull((Object)((Object)benefitsManage), (String)"\u6743\u76ca\u672a\u627e\u5230", (Object[])new Object[0]);
        BenefitsManageVo benefitsManageVo = (BenefitsManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)benefitsManage, BenefitsManageVo.class, HashSet.class, LinkedList.class, new String[0]);
        benefitsManageVo.setList(this.benefitsManageOrgService.findListVoByBenefitsManageId(id));
        return benefitsManageVo;
    }

    @Override
    @Transactional
    public BenefitsManageVo create(BenefitsManageVo benefitsManageVo) {
        this.createValidation(benefitsManageVo);
        BenefitsManage benefitsManage = (BenefitsManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)benefitsManageVo, BenefitsManage.class, HashSet.class, LinkedList.class, new String[0]));
        benefitsManage.setTenantCode(TenantUtils.getTenantCode());
        benefitsManage.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        benefitsManage.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        benefitsManage.setCode((String)this.generateCodeService.generateCode("QY", 5).get(0));
        this.benefitsManageRepository.saveOrUpdate((Object)benefitsManage);
        if (CollectionUtils.isNotEmpty((Collection)benefitsManageVo.getList())) {
            for (BenefitsManageOrgVo benefitsManageOrgVo : benefitsManageVo.getList()) {
                benefitsManageOrgVo.setId(null);
                benefitsManageOrgVo.setBenefitsManageId(benefitsManage.getId());
                benefitsManageOrgVo.setBenefitsManageCode(benefitsManage.getCode());
            }
            this.benefitsManageOrgService.saveBatch(benefitsManageVo.getList());
        }
        return benefitsManageVo;
    }

    @Override
    @Transactional
    public BenefitsManageVo update(BenefitsManageVo benefitsManageVo) {
        this.updateValidation(benefitsManageVo);
        String currentId = benefitsManageVo.getId();
        BenefitsManage current = this.benefitsManageRepository.findById(currentId);
        current = (BenefitsManage)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (BenefitsManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)benefitsManageVo, BenefitsManage.class, HashSet.class, LinkedList.class, new String[0]));
        this.benefitsManageRepository.saveOrUpdate((Object)current);
        List<BenefitsManageOrg> oldList = this.benefitsManageOrgService.findListByBenefitsManageId(current.getId());
        if (CollectionUtils.isNotEmpty(oldList)) {
            List<String> ids = oldList.stream().map(UuidEntity::getId).collect(Collectors.toList());
            this.benefitsManageOrgService.updateDelFlagByIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)benefitsManageVo.getList())) {
            for (BenefitsManageOrgVo benefitsManageOrgVo : benefitsManageVo.getList()) {
                benefitsManageOrgVo.setId(null);
                benefitsManageOrgVo.setBenefitsManageId(current.getId());
                benefitsManageOrgVo.setBenefitsManageCode(current.getCode());
            }
            this.benefitsManageOrgService.saveBatch(benefitsManageVo.getList());
        }
        return benefitsManageVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.benefitsManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.benefitsManageRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.benefitsManageRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<BenefitsManageVo> findDetailByCodes(Set<String> benefitsCodes) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(benefitsCodes), (String)"\u6743\u76ca\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.benefitsManageRepository.lambdaQuery().in(BenefitsManage::getCode, benefitsCodes)).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, BenefitsManage.class, BenefitsManageVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(BenefitsManageVo benefitsManageVo) {
        this.validation(benefitsManageVo);
    }

    private void updateValidation(BenefitsManageVo benefitsManageVo) {
        this.validation(benefitsManageVo);
    }

    private void validation(BenefitsManageVo benefitsManageVo) {
        Validate.notBlank((CharSequence)benefitsManageVo.getName(), (String)"\u6743\u76ca\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)benefitsManageVo.getType(), (String)"\u6743\u76ca\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)benefitsManageVo.getExchangeValidPeriod(), (String)"\u5151\u6362\u6709\u6548\u671f(\u6708)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)benefitsManageVo.getUseValidPeriod(), (String)"\u4f7f\u7528\u6709\u6548\u671f(\u5929)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

