/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.member.business.member.local.entity.CardProduct;
import com.biz.crm.member.business.member.local.repository.CardProductRepository;
import com.biz.crm.member.business.member.local.service.CardProductService;
import com.biz.crm.member.business.member.sdk.dto.CardProductDto;
import com.biz.crm.member.business.member.sdk.vo.CardProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CardProductServiceImpl
implements CardProductService {
    @Autowired
    private CardProductRepository cardProductRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private LoginUserService loginUserService;
    public static final String MMS_CARD_PRODUCT_CODE_REDIS_KEY = "mms:card:product:code:index:%s";
    public static final String MMS_CARD_PRODUCT_CODE_PREFIX = "CP";

    private String generateCode(String tenantCode) {
        String redisKey = String.format(MMS_CARD_PRODUCT_CODE_REDIS_KEY, tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{MMS_CARD_PRODUCT_CODE_PREFIX, format.format(new Date()), index});
    }

    @Override
    public Page<CardProductVo> findByConditions(Pageable pageable, CardProductDto cardProductDto) {
        if (Objects.isNull(cardProductDto)) {
            cardProductDto = new CardProductDto();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.cardProductRepository.findByConditions((Page<CardProductVo>)page, cardProductDto);
    }

    @Override
    public CardProductVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CardProduct cardProduct = (CardProduct)((Object)this.cardProductRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)cardProduct), (String)"\u540d\u7247\u4ea7\u54c1\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        return (CardProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)cardProduct, CardProductVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    public CardProductVo create(CardProductDto cardProductDto) {
        Validate.notNull((Object)cardProductDto, (String)"\u65b0\u589e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cardProductDto.getName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String code = this.generateCode(TenantUtils.getTenantCode());
        cardProductDto.setCode(code);
        cardProductDto.setTenantCode(TenantUtils.getTenantCode());
        cardProductDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        cardProductDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        CardProduct cardProduct = (CardProduct)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)cardProductDto, CardProduct.class, HashSet.class, LinkedList.class, new String[0]));
        this.cardProductRepository.saveOrUpdate((Object)cardProduct);
        return (CardProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)cardProduct, CardProductVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    public CardProductVo update(CardProductDto cardProductDto) {
        Validate.notNull((Object)cardProductDto, (String)"\u7f16\u8f91\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cardProductDto.getName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        cardProductDto.setTenantCode(TenantUtils.getTenantCode());
        cardProductDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        cardProductDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        CardProduct cardProduct = (CardProduct)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)cardProductDto, CardProduct.class, HashSet.class, LinkedList.class, new String[0]));
        this.cardProductRepository.saveOrUpdate((Object)cardProduct);
        return (CardProductVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)cardProduct, CardProductVo.class, HashSet.class, LinkedList.class, new String[0]);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.cardProductRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.cardProductRepository.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, ids)).update();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.cardProductRepository.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
    }
}

