/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.ChoiceNessCategory;
import com.biz.crm.member.business.member.local.repository.ChoiceNessCategoryRepository;
import com.biz.crm.member.business.member.local.service.ChoiceNessCategoryService;
import com.biz.crm.member.business.member.sdk.dto.ChoiceNessCategoryDto;
import com.biz.crm.member.business.member.sdk.dto.ChoiceNessCategoryPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.ChoiceNessCategoryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChoiceNessCategoryServiceImpl
implements ChoiceNessCategoryService {
    private static final Logger log = LoggerFactory.getLogger(ChoiceNessCategoryServiceImpl.class);
    @Autowired
    private ChoiceNessCategoryRepository choiceNessCategoryRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    public ChoiceNessCategoryVo createChoiceNessCategory(ChoiceNessCategoryDto dto) {
        this.createValidation(dto);
        ChoiceNessCategory choiceNessCategory = (ChoiceNessCategory)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ChoiceNessCategory.class, HashSet.class, LinkedList.class, new String[0]));
        choiceNessCategory.setTenantCode(TenantUtils.getTenantCode());
        choiceNessCategory.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        choiceNessCategory.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        choiceNessCategory.setCode((String)this.generateCodeService.generateCode("JX", 5).get(0));
        this.choiceNessCategoryRepository.save((Object)choiceNessCategory);
        ChoiceNessCategoryVo result = (ChoiceNessCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)choiceNessCategory, ChoiceNessCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    @Override
    public ChoiceNessCategoryVo updateChoiceNessCategory(ChoiceNessCategoryDto dto) {
        String id = dto.getId();
        Optional.ofNullable(dto.getChoiceSort()).ifPresent(sort -> Validate.isTrue((sort > 0 ? 1 : 0) != 0, (String)"\u6392\u5e8f\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]));
        Validate.notBlank((CharSequence)id, (String)"\u4fee\u6539\u7cbe\u9009\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ChoiceNessCategory category = (ChoiceNessCategory)((Object)this.choiceNessCategoryRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)category), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ChoiceNessCategory choiceNessCategory = (ChoiceNessCategory)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ChoiceNessCategory.class, HashSet.class, LinkedList.class, new String[0]));
        this.choiceNessCategoryRepository.saveOrUpdate((Object)choiceNessCategory);
        ChoiceNessCategoryVo result = (ChoiceNessCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)choiceNessCategory, ChoiceNessCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    @Override
    public ChoiceNessCategoryVo getChoiceNessCategoryById(String id) {
        Validate.notBlank((CharSequence)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ChoiceNessCategory category = (ChoiceNessCategory)((Object)this.choiceNessCategoryRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)category), (String)"\u67e5\u8be2\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ChoiceNessCategoryVo result = (ChoiceNessCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)category, ChoiceNessCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    @Override
    public Page<ChoiceNessCategoryVo> pageChoiceNessCategory(Pageable pageable, ChoiceNessCategoryPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ChoiceNessCategoryPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ChoiceNessCategoryVo> result = this.choiceNessCategoryRepository.pageChoiceNessCategory((Page<ChoiceNessCategoryVo>)page, dto);
        return result;
    }

    @Override
    @Transactional
    public void turnOnCategory(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.choiceNessCategoryRepository.batchUpdateStatus(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void turnOffCategory(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.choiceNessCategoryRepository.batchUpdateStatus(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void logicDeleteCategory(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.choiceNessCategoryRepository.batchLogicDeleteCategory(ids);
    }

    @Override
    public List<ChoiceNessCategoryVo> appListEnableChoiceNessCategory() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByAsc(ChoiceNessCategory::getChoiceSort)).orderByDesc(UuidOpEntity::getModifyTime)).orderByDesc(UuidOpEntity::getCreateTime)).last("limit 3");
        List categoryList = this.choiceNessCategoryRepository.list((Wrapper)queryWrapper);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)categoryList, ChoiceNessCategory.class, ChoiceNessCategoryVo.class, HashSet.class, LinkedList.class, new String[0]);
        return (List)result;
    }

    private void createValidation(ChoiceNessCategoryDto dto) {
        this.validation(dto);
    }

    private void validation(ChoiceNessCategoryDto dto) {
        Validate.notBlank((CharSequence)dto.getChoiceNessName(), (String)"\u7cbe\u9009\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getChoiceSort(), (String)"\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCategoryPic(), (String)"\u5206\u7c7b\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getChoiceSort() > 0 ? 1 : 0) != 0, (String)"\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
    }
}

