/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.CulturalAndTourismRespondent;
import com.biz.crm.member.business.member.local.entity.CulturalAndTourismTopic;
import com.biz.crm.member.business.member.local.entity.SystemSettingsDetail;
import com.biz.crm.member.business.member.local.mapper.CulturalAndTourismTopicMapper;
import com.biz.crm.member.business.member.local.repository.CulturalAndTourismRespondentRepository;
import com.biz.crm.member.business.member.local.repository.CulturalAndTourismTopicRepository;
import com.biz.crm.member.business.member.local.service.CulturalAndTourismRespondentService;
import com.biz.crm.member.business.member.local.service.MemberInfoIntegralRecordService;
import com.biz.crm.member.business.member.local.service.SystemSettingsDetailService;
import com.biz.crm.member.business.member.sdk.dto.CulturalAndTourismRespondentPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.IntegralSourceEnum;
import com.biz.crm.member.business.member.sdk.enums.SystemSettingsDetailEnum;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismInitAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismRespondentAPIVo;
import com.biz.crm.member.business.member.sdk.vo.CulturalAndTourismRespondentVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoIntegralRecordVo;
import com.biz.crm.member.business.member.sdk.vo.SystemSettingsDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="culturalAndTourismRespondentServiceImpl")
public class CulturalAndTourismRespondentServiceImpl
implements CulturalAndTourismRespondentService {
    private static final Logger log = LoggerFactory.getLogger(CulturalAndTourismRespondentServiceImpl.class);
    @Autowired
    private CulturalAndTourismRespondentRepository culturalAndTourismRespondentRepository;
    @Autowired
    private CulturalAndTourismTopicMapper culturalAndTourismTopicMapper;
    @Autowired
    private CulturalAndTourismTopicRepository culturalAndTourismTopicRepository;
    @Autowired
    private MemberInfoIntegralRecordService memberInfoIntegralRecordService;
    @Autowired
    private SystemSettingsDetailService systemSettingsDetailService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<CulturalAndTourismRespondentVo> findByConditions(Pageable pageable, CulturalAndTourismRespondentPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new CulturalAndTourismRespondentPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.culturalAndTourismRespondentRepository.findByConditions((Page<CulturalAndTourismRespondentVo>)page, dto);
    }

    @Override
    public CulturalAndTourismInitAPIVo initData(String phone) {
        CulturalAndTourismInitAPIVo culturalAndTourismInitAPIVo = new CulturalAndTourismInitAPIVo();
        Integer number = this.count(phone);
        Integer points = this.earnPoints(phone);
        Integer times = this.numberOfQuestionsLeftThisMonth(phone);
        SystemSettingsDetailVo result = this.activityRules();
        culturalAndTourismInitAPIVo.setAnsweredQuestionsTimes(number);
        culturalAndTourismInitAPIVo.setEarnPoints(points);
        culturalAndTourismInitAPIVo.setNumberOfQuestionsLeftThisMonth(times);
        culturalAndTourismInitAPIVo.setActivityRules(result.getTypeValueText());
        return culturalAndTourismInitAPIVo;
    }

    @Override
    @Transactional
    public CulturalAndTourismRespondentAPIVo create(CulturalAndTourismRespondentAPIVo culturalAndTourismRespondentAPIVo) {
        Validate.notBlank((CharSequence)culturalAndTourismRespondentAPIVo.getMemberCode(), (String)"\u4f1a\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CulturalAndTourismRespondentVo culturalAndTourismRespondentVo = (CulturalAndTourismRespondentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)culturalAndTourismRespondentAPIVo, CulturalAndTourismRespondentVo.class, HashSet.class, LinkedList.class, new String[0]);
        this.createValidation(culturalAndTourismRespondentVo);
        CulturalAndTourismRespondent culturalAndTourismRespondent = (CulturalAndTourismRespondent)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)culturalAndTourismRespondentAPIVo, CulturalAndTourismRespondent.class, HashSet.class, LinkedList.class, new String[0]));
        Integer points = this.thisTimeEarnPoints(culturalAndTourismRespondentVo.getPhone());
        culturalAndTourismRespondent.setTenantCode(TenantUtils.getTenantCode());
        culturalAndTourismRespondent.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        culturalAndTourismRespondent.setPoints(points);
        culturalAndTourismRespondent.setAnswerTime(new Date());
        culturalAndTourismRespondent.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        culturalAndTourismRespondent.setCode((String)this.generateCodeService.generateCode("WN", 5).get(0));
        this.culturalAndTourismRespondentRepository.saveOrUpdate((Object)culturalAndTourismRespondent);
        String phone = culturalAndTourismRespondentAPIVo.getPhone();
        String answerResult = culturalAndTourismRespondentAPIVo.getAnswerResult();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CulturalAndTourismTopic::getCode, (Object)culturalAndTourismRespondentAPIVo.getCode());
        CulturalAndTourismTopic culturalAndTourismTopic = (CulturalAndTourismTopic)((Object)this.culturalAndTourismTopicMapper.selectOne((Wrapper)queryWrapper));
        Validate.notNull((Object)((Object)culturalAndTourismTopic), (String)"\u9898\u76ee\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.updateCulturalAndTourismTopic(phone, answerResult, culturalAndTourismTopic);
        if (points > 0) {
            MemberInfoIntegralRecordVo memberInfoIntegralRecordVo = (MemberInfoIntegralRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)culturalAndTourismRespondentAPIVo, MemberInfoIntegralRecordVo.class, HashSet.class, LinkedList.class, new String[0]);
            memberInfoIntegralRecordVo.setMemberCode(culturalAndTourismRespondentAPIVo.getMemberCode());
            memberInfoIntegralRecordVo.setSource(IntegralSourceEnum.CULTURAL_TOURISM_TOPIC.getValue());
            memberInfoIntegralRecordVo.setType(IntegralSourceEnum.CULTURAL_TOURISM_TOPIC.getType());
            memberInfoIntegralRecordVo.setIntegral(points);
            this.memberInfoIntegralRecordService.commonInternal(memberInfoIntegralRecordVo);
        }
        return culturalAndTourismRespondentAPIVo;
    }

    @Override
    public Integer count(String phone) {
        return ((LambdaQueryChainWrapper)this.culturalAndTourismRespondentRepository.lambdaQuery().eq(CulturalAndTourismRespondent::getPhone, (Object)phone)).count();
    }

    @Override
    public Integer earnPoints(String phone) {
        List list = ((LambdaQueryChainWrapper)this.culturalAndTourismRespondentRepository.lambdaQuery().eq(CulturalAndTourismRespondent::getPhone, (Object)phone)).list();
        int sum = list.stream().map(CulturalAndTourismRespondent::getPoints).mapToInt(Integer::intValue).sum();
        return sum;
    }

    @Override
    public Integer numberOfQuestionsLeftThisMonth(String phone) {
        LocalDate now = LocalDate.now();
        LocalDate firstDay = now.withDayOfMonth(1);
        log.info("========================{}", (Object)firstDay);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.culturalAndTourismRespondentRepository.lambdaQuery().eq(CulturalAndTourismRespondent::getPhone, (Object)phone)).gt(CulturalAndTourismRespondent::getAnswerTime, (Object)firstDay)).list();
        int sum = list.stream().map(CulturalAndTourismRespondent::getPoints).mapToInt(Integer::intValue).sum();
        String answeringCorrectPointsString = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.ANSWERING_CORRECTLY_POINTS.getValue()).getTypeValue();
        answeringCorrectPointsString = Optional.ofNullable(answeringCorrectPointsString).orElse("0");
        int answeringCorrectPoints = Integer.parseInt(answeringCorrectPointsString);
        String maxPointsPerMonthString = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.MAX_POINTS_PER_MONTH.getValue()).getTypeValue();
        maxPointsPerMonthString = Optional.ofNullable(maxPointsPerMonthString).orElse("0");
        int maxPointsPerMonth = Integer.parseInt(maxPointsPerMonthString);
        if (answeringCorrectPoints == 0) {
            return 99;
        }
        int times = (maxPointsPerMonth - sum) / answeringCorrectPoints;
        if ((maxPointsPerMonth - sum) % answeringCorrectPoints != 0) {
            ++times;
        }
        return times;
    }

    @Override
    public SystemSettingsDetailVo activityRules() {
        SystemSettingsDetail systemSettingsDetail = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.ACTIVITY_RULES.getValue());
        SystemSettingsDetailVo systemSettingsDetailVo = (SystemSettingsDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)systemSettingsDetail, SystemSettingsDetailVo.class, HashSet.class, LinkedList.class, new String[0]);
        return systemSettingsDetailVo;
    }

    private Integer thisTimeEarnPoints(String phone) {
        LocalDate now = LocalDate.now();
        LocalDate firstDay = now.withDayOfMonth(1);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.culturalAndTourismRespondentRepository.lambdaQuery().eq(CulturalAndTourismRespondent::getPhone, (Object)phone)).gt(CulturalAndTourismRespondent::getAnswerTime, (Object)firstDay)).list();
        int sum = list.stream().map(CulturalAndTourismRespondent::getPoints).mapToInt(Integer::intValue).sum();
        String answeringCorrectPointsString = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.ANSWERING_CORRECTLY_POINTS.getValue()).getTypeValue();
        int answeringCorrectPoints = Integer.parseInt(answeringCorrectPointsString);
        String maxPointsPerMonthString = this.systemSettingsDetailService.findValueByKey(SystemSettingsDetailEnum.MAX_POINTS_PER_MONTH.getValue()).getTypeValue();
        int maxPointsPerMonth = Integer.parseInt(maxPointsPerMonthString);
        if (maxPointsPerMonth - sum >= answeringCorrectPoints) {
            return answeringCorrectPoints;
        }
        return maxPointsPerMonth - sum;
    }

    private void updateCulturalAndTourismTopic(String phone, String answerResult, CulturalAndTourismTopic culturalAndTourismTopic) {
        Integer correctPeopleTimes = culturalAndTourismTopic.getCorrectPeopleTimes();
        correctPeopleTimes = Optional.ofNullable(correctPeopleTimes).orElse(0);
        Integer correctTimes = culturalAndTourismTopic.getCorrectTimes();
        correctTimes = Optional.ofNullable(correctTimes).orElse(0);
        Integer commitPeopleTimes = culturalAndTourismTopic.getCommitPeopleTimes();
        commitPeopleTimes = Optional.ofNullable(commitPeopleTimes).orElse(0);
        Integer commitTimes = culturalAndTourismTopic.getCommitTimes();
        commitTimes = Optional.ofNullable(commitTimes).orElse(0);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.culturalAndTourismRespondentRepository.lambdaQuery().eq(CulturalAndTourismRespondent::getPhone, (Object)phone)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (list.isEmpty()) {
            if (Boolean.parseBoolean(answerResult)) {
                commitPeopleTimes = commitPeopleTimes + 1;
                culturalAndTourismTopic.setCommitPeopleTimes(commitPeopleTimes);
                commitTimes = commitTimes + 1;
                culturalAndTourismTopic.setCommitTimes(commitTimes);
                correctPeopleTimes = correctPeopleTimes + 1;
                culturalAndTourismTopic.setCorrectPeopleTimes(correctPeopleTimes);
                correctTimes = correctTimes + 1;
                culturalAndTourismTopic.setCorrectTimes(correctTimes);
                this.culturalAndTourismTopicRepository.saveOrUpdate((Object)culturalAndTourismTopic);
            } else {
                commitPeopleTimes = commitPeopleTimes + 1;
                culturalAndTourismTopic.setCommitPeopleTimes(commitPeopleTimes);
                commitTimes = commitTimes + 1;
                culturalAndTourismTopic.setCommitTimes(commitTimes);
                this.culturalAndTourismTopicRepository.saveOrUpdate((Object)culturalAndTourismTopic);
            }
        } else if (Boolean.parseBoolean(answerResult)) {
            commitTimes = commitTimes + 1;
            culturalAndTourismTopic.setCommitTimes(commitTimes);
            correctTimes = correctTimes + 1;
            culturalAndTourismTopic.setCorrectTimes(correctTimes);
            this.culturalAndTourismTopicRepository.saveOrUpdate((Object)culturalAndTourismTopic);
        } else {
            commitTimes = commitTimes + 1;
            culturalAndTourismTopic.setCommitTimes(commitTimes);
            this.culturalAndTourismTopicRepository.saveOrUpdate((Object)culturalAndTourismTopic);
        }
    }

    private void createValidation(CulturalAndTourismRespondentVo culturalAndTourismRespondentVo) {
        this.validation(culturalAndTourismRespondentVo);
    }

    private void updateValidation(CulturalAndTourismRespondentVo culturalAndTourismRespondentVo) {
        this.validation(culturalAndTourismRespondentVo);
    }

    private void validation(CulturalAndTourismRespondentVo culturalAndTourismRespondentVo) {
        Validate.notBlank((CharSequence)culturalAndTourismRespondentVo.getCode(), (String)"\u9898\u76eecode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)culturalAndTourismRespondentVo.getName(), (String)"\u9898\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)culturalAndTourismRespondentVo.getRightAnswer(), (String)"\u6b63\u786e\u7b54\u6848\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)culturalAndTourismRespondentVo.getSelectAnswer(), (String)"\u9009\u62e9\u7b54\u6848\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)culturalAndTourismRespondentVo.getAnswerResult(), (String)"\u7b54\u9898\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)culturalAndTourismRespondentVo.getPhone(), (String)"\u7b54\u9898\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)culturalAndTourismRespondentVo.getName(), (String)"\u7b54\u9898\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

