/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.Discuss;
import com.biz.crm.member.business.member.local.entity.MemberInfo;
import com.biz.crm.member.business.member.local.entity.MemberInfoAssets;
import com.biz.crm.member.business.member.local.entity.TastingConsultant;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.DiscussRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoAssetsRepository;
import com.biz.crm.member.business.member.local.repository.MemberInfoRepository;
import com.biz.crm.member.business.member.local.repository.TastingConsultantRepository;
import com.biz.crm.member.business.member.local.service.DiscussService;
import com.biz.crm.member.business.member.sdk.dto.DiscussDto;
import com.biz.crm.member.business.member.sdk.dto.DiscussPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.DiscussCheckStatusEnum;
import com.biz.crm.member.business.member.sdk.vo.DiscussVo;
import com.biz.crm.member.business.member.sdk.vo.InfoCountDto;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DiscussServiceImpl
implements DiscussService {
    private static final Logger log = LoggerFactory.getLogger(DiscussServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DiscussRepository discussRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired
    private MemberInfoRepository memberInfoRepository;
    @Autowired
    private MemberInfoAssetsRepository memberInfoAssetsRepository;
    @Autowired
    private TastingConsultantRepository tastingConsultantRepository;

    @Override
    public DiscussVo createDiscuss(DiscussDto dto) {
        Boolean enableDiscuss = this.enableDiscuss();
        Validate.isTrue((boolean)enableDiscuss, (String)"\u5f53\u524d\u7528\u6237\u6743\u9650\u4e0d\u8db3\uff0c\u4e0d\u80fd\u8bc4\u8bba", (Object[])new Object[0]);
        String memberPhone = this.userSearchHelper.getMemberLogin().getMemberPhone();
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        dto.setDiscussTel(memberPhone);
        this.createValidate(dto);
        Discuss discuss = (Discuss)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, Discuss.class, HashSet.class, LinkedList.class, new String[0]));
        discuss.setChoiceDiscuss(0);
        discuss.setMemberCode(memberCode);
        discuss.setCheckStatus(DiscussCheckStatusEnum.WAITING.getValue());
        discuss.setCode((String)this.generateCodeService.generateCode("PL", 5).get(0));
        discuss.setTenantCode(TenantUtils.getTenantCode());
        discuss.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        discuss.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.discussRepository.save((Object)discuss);
        DiscussVo result = (DiscussVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)discuss, DiscussVo.class, HashSet.class, LinkedList.class, new String[0]);
        return result;
    }

    @Override
    @Transactional
    public void logicDeleteByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.discussRepository.logicDeleteByIds(ids);
    }

    @Override
    @Transactional
    public void batchModifyCheckStatus(List<String> ids, String checkStatus) {
        List discusses;
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)checkStatus, (String)"\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List discussList = this.discussRepository.listByIds(ids);
        if (DiscussCheckStatusEnum.APPROVE.getValue().equals(checkStatus)) {
            discusses = discussList.stream().filter(discuss -> {
                String refuseValue = DiscussCheckStatusEnum.REFUSE.getValue();
                return discuss.getCheckStatus().equals(refuseValue);
            }).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(discusses), (String)"\u975e\u5f85\u5ba1\u6279\u72b6\u6001\u7684\u8bc4\u8bba\u4e0d\u80fd\u901a\u8fc7\u5ba1\u6279\uff01", (Object[])new Object[0]);
        }
        if (DiscussCheckStatusEnum.REFUSE.getValue().equals(checkStatus)) {
            discusses = discussList.stream().filter(discuss -> {
                String approveValue = DiscussCheckStatusEnum.APPROVE.getValue();
                return discuss.getCheckStatus().equals(approveValue);
            }).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(discusses), (String)"\u975e\u5f85\u5ba1\u6279\u72b6\u6001\u7684\u8bc4\u8bba\u4e0d\u80fd\u76f4\u63a5\u9a73\u56de\uff01", (Object[])new Object[0]);
        }
        this.discussRepository.modifyCheckStatusByIds(ids, checkStatus);
    }

    @Override
    @Transactional
    public void turnOnDiscuss(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.discussRepository.modifyEnableStatus(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void turnOffDiscuss(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.discussRepository.modifyEnableStatus(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void batchModifyChoiceDiscuss(List<String> ids, Integer choiceDiscuss) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.discussRepository.modifyChoiceDiscuss(ids, choiceDiscuss);
    }

    @Override
    public Page<DiscussVo> pageDiscuss(Pageable pageable, DiscussPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new DiscussPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<DiscussVo> result = this.discussRepository.pageDiscussInfo((Page<DiscussVo>)page, dto);
        return result;
    }

    @Override
    public List<InfoCountDto> countByInfoCodes(List<String> infoCodes, String checkStatus, String enableStatus) {
        if (CollectionUtils.isEmpty(infoCodes)) {
            return Collections.EMPTY_LIST;
        }
        List<InfoCountDto> result = this.discussRepository.countByInfoCodes(infoCodes, checkStatus, enableStatus);
        return result;
    }

    @Override
    public Page<DiscussVo> appPageDiscussByInfoCode(Pageable pageable, String infoCode) {
        Validate.notBlank((CharSequence)infoCode, (String)"\u8d44\u8baf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        Page<DiscussVo> result = this.discussRepository.appPageDiscussByInfoCode((Page<DiscussVo>)page, infoCode, memberCode);
        return result;
    }

    @Override
    public Boolean enableDiscuss() {
        MemberUserDetails memberLogin = this.userSearchHelper.getMemberLogin();
        String memberCode = memberLogin.getMemberCode();
        String memberPhone = memberLogin.getMemberPhone();
        MemberInfoAssets memberInfoAssets = (MemberInfoAssets)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.memberInfoAssetsRepository.lambdaQuery().eq(MemberInfoAssets::getMemberCode, (Object)memberCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).one());
        TastingConsultant tastingConsultant = (TastingConsultant)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tastingConsultantRepository.lambdaQuery().eq(TastingConsultant::getPhone, (Object)memberPhone)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).last("limit 1")).orderByDesc(UuidOpEntity::getCreateTime)).one());
        return ObjectUtils.isNotEmpty((Object)memberCode) || ObjectUtils.isNotEmpty((Object)((Object)tastingConsultant));
    }

    @Override
    public List<DiscussVo> appListOwnerDiscussLimit(String infoCode) {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        List discussList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.discussRepository.lambdaQuery().eq(Discuss::getMemberCode, (Object)memberCode)).eq(Discuss::getInfoCode, (Object)infoCode)).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(Discuss::getCheckStatus, (Object)DiscussCheckStatusEnum.APPROVE.getValue())).orderByDesc(UuidOpEntity::getCreateTime)).last("limit 3")).list();
        if (CollectionUtils.isEmpty((Collection)discussList)) {
            discussList = Collections.EMPTY_LIST;
        }
        List memberCodes = discussList.stream().map(Discuss::getMemberCode).distinct().collect(Collectors.toList());
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)discussList, Discuss.class, DiscussVo.class, HashSet.class, LinkedList.class, new String[0]);
        if (CollectionUtils.isNotEmpty(memberCodes)) {
            Map<String, String> memberInfoMap = ((LambdaQueryChainWrapper)this.memberInfoRepository.lambdaQuery().in(MemberInfo::getMemberCode, memberCodes)).list().stream().collect(Collectors.toMap(MemberInfo::getMemberCode, MemberInfo::getMemberAvatar));
            result.forEach(discussVo -> discussVo.setAvatar((String)memberInfoMap.get(discussVo.getMemberCode())));
        }
        return (List)result;
    }

    private void populateBelongOwner(List<DiscussVo> records) {
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        for (DiscussVo record : records) {
            String discussMemberCode = record.getMemberCode();
            record.setOwner(Boolean.valueOf(memberCode.equals(discussMemberCode)));
        }
    }

    private void createValidate(DiscussDto dto) {
        this.validate(dto);
    }

    private void validate(DiscussDto dto) {
        Validate.notBlank((CharSequence)dto.getInfoCode(), (String)"\u8d44\u8baf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getInfoTitle(), (String)"\u8d44\u8baf\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDiscussContent(), (String)"\u8bc4\u8bba\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

