/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.member.business.member.local.entity.DummyOrder;
import com.biz.crm.member.business.member.local.entity.VerificationUser;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.DummyOrderRepository;
import com.biz.crm.member.business.member.local.repository.VerificationUserRepository;
import com.biz.crm.member.business.member.local.service.DummyOrderService;
import com.biz.crm.member.business.member.local.service.DummyOrderUserService;
import com.biz.crm.member.business.member.local.service.MemberInfoArchivesService;
import com.biz.crm.member.business.member.local.service.MemberInfoService;
import com.biz.crm.member.business.member.sdk.dto.AppOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderPaginationDto;
import com.biz.crm.member.business.member.sdk.enums.AppDummyOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.DummyOrderStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.OrderSettleStatusEnum;
import com.biz.crm.member.business.member.sdk.enums.VerificationUserTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoArchivesVo;
import com.biz.crm.member.business.member.sdk.vo.MemberInfoVo;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dummyOrderService")
public class DummyOrderServiceImpl
implements DummyOrderService {
    private static final Logger log = LoggerFactory.getLogger(DummyOrderServiceImpl.class);
    @Autowired(required=false)
    private DummyOrderRepository dummyOrderRepository;
    @Autowired(required=false)
    private DummyOrderUserService dummyOrderUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private UserSearchHelper userSearchHelper;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired
    private MemberInfoArchivesService memberInfoArchivesService;
    @Autowired
    private MemberInfoService memberInfoService;
    @Autowired
    private VerificationUserRepository verificationUserRepository;
    @Autowired
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;
    @Value(value="${crm.business.dummyorder.process-key:}")
    private String defaultProcessKey;
    private static final Set<String> STATUS_SET = Sets.newHashSet((Object[])new String[]{ProcessStatusEnum.PREPARE.getDictCode(), ProcessStatusEnum.PASS.getDictCode(), ProcessStatusEnum.REJECT.getDictCode(), ProcessStatusEnum.RECOVER.getDictCode()});

    @Override
    public Page<DummyOrderVo> findByConditions(Pageable pageable, DummyOrderPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new DummyOrderPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.dummyOrderRepository.findByConditions((Page<DummyOrderVo>)page, dto);
    }

    @Override
    public DummyOrderVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DummyOrder dummyOrder = this.dummyOrderRepository.findById(id);
        DummyOrderVo dummyOrderVo = (DummyOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dummyOrder, DummyOrderVo.class, HashSet.class, LinkedList.class, new String[0]);
        return dummyOrderVo;
    }

    @Override
    @Transactional
    public DummyOrderVo create(DummyOrderVo dummyOrderVo) {
        OrgVo orgVo;
        this.createValidation(dummyOrderVo);
        DummyOrder dummyOrder = (DummyOrder)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dummyOrderVo, DummyOrder.class, HashSet.class, LinkedList.class, new String[0]));
        dummyOrder.setTenantCode(TenantUtils.getTenantCode());
        dummyOrder.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dummyOrder.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        MemberInfoVo memberInfoVo = this.memberInfoService.findDetailByMemberCode(dummyOrder.getUserCode());
        Validate.notNull((Object)memberInfoVo, (String)"\u4f1a\u5458\u4fe1\u606f\u5f02\u5e38", (Object[])new Object[0]);
        MemberInfoArchivesVo memberInfoArchivesVo = this.memberInfoArchivesService.findDetailByMemberCode(dummyOrder.getUserCode());
        Validate.notNull((Object)memberInfoArchivesVo, (String)"\u4f1a\u5458\u6863\u6848\u4fe1\u606f\u5f02\u5e38", (Object[])new Object[0]);
        List orgVos = this.orgVoService.findByOrgCodes(Arrays.asList(memberInfoArchivesVo.getOrgCode()));
        if (CollectionUtils.isNotEmpty((Collection)orgVos) && (orgVo = (OrgVo)orgVos.get(0)) != null) {
            dummyOrder.setOrgCode(orgVo.getOrgCode());
            dummyOrder.setOrgName(orgVo.getOrgName());
        }
        dummyOrder.setOrderCode((String)this.generateCodeService.generateCode("XN", 5).get(0));
        dummyOrder.setUserName(memberInfoVo.getMemberName());
        dummyOrder.setOrderTime(new Date());
        dummyOrder.setOrderName(memberInfoVo.getMemberName());
        dummyOrder.setOrderPhone(memberInfoVo.getMemberPhone());
        this.dummyOrderRepository.saveOrUpdate((Object)dummyOrder);
        for (DummyOrderUserVo dummyOrderUserVo : dummyOrderVo.getList()) {
            dummyOrderUserVo.setOrderCode(dummyOrder.getOrderCode());
        }
        this.dummyOrderUserService.batchSave(dummyOrderVo.getList());
        dummyOrderVo.setOrderCode(dummyOrder.getOrderCode());
        dummyOrderVo.setId(dummyOrder.getId());
        return dummyOrderVo;
    }

    @Override
    @Transactional
    public DummyOrderVo update(DummyOrderVo dummyOrderVo) {
        this.updateValidation(dummyOrderVo);
        String currentId = dummyOrderVo.getId();
        DummyOrder current = this.dummyOrderRepository.findById(currentId);
        current = (DummyOrder)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (DummyOrder)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dummyOrderVo, DummyOrder.class, HashSet.class, LinkedList.class, new String[0]));
        this.dummyOrderRepository.saveOrUpdate((Object)current);
        return dummyOrderVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dummyOrderRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dummyOrderRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dummyOrderRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<DummyOrderUserVo> userInfoList(String orderCode) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<DummyOrderUserVo> list = this.dummyOrderUserService.userInfoList(orderCode);
        return list;
    }

    @Override
    public void batchWriteOff(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dummyOrderRepository.updateWriteOffByIds(ids);
    }

    @Override
    @Transactional
    public void settleSubmit(DummyOrderVo dummyOrderVo) {
        Validate.notBlank((CharSequence)dummyOrderVo.getId(), (String)"\u8bf7\u9009\u62e9\u8ba2\u5355", (Object[])new Object[0]);
        DummyOrder dummyOrder = this.dummyOrderRepository.findById(dummyOrderVo.getId());
        Validate.notNull((Object)((Object)dummyOrder), (String)"\u865a\u62df\u8ba2\u5355\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.equals(OrderSettleStatusEnum.STAY_SETTLE.getValue(), dummyOrder.getSettleStatus()), (String)"\u8bf7\u9009\u62e9\u672a\u7ed3\u7b97\u8ba2\u5355!", (Object[])new Object[0]);
        dummyOrder.setProcessNumber(this.commitProcess(dummyOrder));
        dummyOrder.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        dummyOrder.setSettleStatus(OrderSettleStatusEnum.LOAD_SETTLE.getValue());
        this.dummyOrderRepository.updateById((Object)dummyOrder);
    }

    @Override
    public Page<DummyOrderVo> appPageDummyOrder(Pageable pageable, AppOrderPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AppOrderPaginationDto());
        this.appPageValidate(dto);
        String orderStatus = dto.getOrderStatus();
        String orderStatusAll = AppDummyOrderStatusEnum.ALL.getValue();
        if (orderStatusAll.equals(orderStatus)) {
            dto.setOrderStatus("");
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        String memberCode = this.userSearchHelper.getMemberLogin().getMemberCode();
        Page<DummyOrderVo> result = this.dummyOrderRepository.appPageDummyOrder((Page<DummyOrderVo>)page, dto, memberCode);
        return result;
    }

    @Override
    public DummyOrderVo findDetailByOrderCode(String orderCode) {
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return null;
        }
        DummyOrder dummyOrder = (DummyOrder)((Object)((LambdaQueryChainWrapper)this.dummyOrderRepository.lambdaQuery().eq(DummyOrder::getOrderCode, (Object)orderCode)).one());
        if (dummyOrder == null) {
            return null;
        }
        DummyOrderVo dummyOrderVo = (DummyOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dummyOrder, DummyOrderVo.class, HashSet.class, LinkedList.class, new String[0]);
        return dummyOrderVo;
    }

    @Override
    public void writeDummyOrderById(String dummyOrderId) {
        Validate.notBlank((CharSequence)dummyOrderId, (String)"\u865a\u62df\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DummyOrder dummyOrder = (DummyOrder)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.dummyOrderRepository.lambdaQuery().eq(UuidEntity::getId, (Object)dummyOrderId)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
        Validate.notNull((Object)((Object)dummyOrder), (String)"\u6838\u9500\u8ba2\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String orderStatus = dummyOrder.getOrderStatus();
        String stayUseValue = DummyOrderStatusEnum.STAY_USE.getValue();
        Validate.isTrue((boolean)stayUseValue.equals(orderStatus), (String)"\u6838\u9500\u5931\u8d25,\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u6838\u9500", (Object[])new Object[0]);
        String writeOffValue = DummyOrderStatusEnum.HAS_WRITE_OFF.getValue();
        MemberUserDetails memberLogin = this.userSearchHelper.getMemberLogin();
        String memberPhone = memberLogin.getMemberPhone();
        VerificationUser verificationUser = (VerificationUser)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.verificationUserRepository.lambdaQuery().eq(VerificationUser::getPhone, (Object)memberPhone)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(VerificationUser::getUserType, (Object)VerificationUserTypeEnum.VIRTUAL.getCode())).one());
        Validate.notNull((Object)((Object)verificationUser), (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e0d\u662f\u865a\u62df\u4ea7\u54c1\u6838\u9500\u4eba\u5458\u6216\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6743\u6838\u9500\u8be5\u8ba2\u5355", (Object[])new Object[0]);
        String userName = verificationUser.getUserName();
        String userCode = verificationUser.getUserCode();
        dummyOrder.setOrderStatus(writeOffValue);
        dummyOrder.setWriteOffTime(new Date(System.currentTimeMillis()));
        dummyOrder.setWriteOffCode(userCode);
        dummyOrder.setWriteOffName(userName);
        this.dummyOrderRepository.saveOrUpdate((Object)dummyOrder);
    }

    private void appPageValidate(AppOrderPaginationDto dto) {
        Validate.notNull((Object)dto, (String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderSource(), (String)"\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderStatus(), (String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void createValidation(DummyOrderVo dummyOrderVo) {
        this.validation(dummyOrderVo);
    }

    private void updateValidation(DummyOrderVo dummyOrderVo) {
        this.validation(dummyOrderVo);
    }

    private void validation(DummyOrderVo dummyOrderVo) {
        Validate.notBlank((CharSequence)dummyOrderVo.getOrderStatus(), (String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dummyOrderVo.getOrderSource(), (String)"\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dummyOrderVo.getUserCode(), (String)"\u5173\u8054\u4f1a\u5458\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dummyOrderVo.getProductImg(), (String)"\u5546\u54c1\u7f29\u7565\u56fe\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dummyOrderVo.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dummyOrderVo.getProductNum(), (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dummyOrderVo.getList()), (String)"\u62a5\u540d\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private String commitProcess(DummyOrder dto) {
        ProcessBusinessDto processBusiness = Optional.ofNullable(dto.getProcessBusiness()).orElse(new ProcessBusinessDto());
        String processKey = processBusiness.getProcessKey();
        if (StringUtils.isBlank((CharSequence)processKey)) {
            processBusiness.setProcessKey(this.defaultProcessKey);
        }
        processBusiness.setBusinessNo(dto.getId());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)((Object)dto)));
        processBusiness.setBusinessCode("mms_dummy_order_create");
        processBusiness.setProcessTitle(dto.getOrderName() + dto.getOrderCode());
        this.processBusinessMappingService.deleteByBusinessNoAndBusinessCodeAndProcessKey(dto.getId(), "mms_dummy_order_create", processBusiness.getProcessKey());
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        return processBusinessVo.getProcessNo();
    }
}

