/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.member.business.member.local.entity.DummyOrderUser;
import com.biz.crm.member.business.member.local.repository.DummyOrderUserRepository;
import com.biz.crm.member.business.member.local.service.DummyOrderUserService;
import com.biz.crm.member.business.member.sdk.dto.DummyOrderUserPaginationDto;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderApplyUserVo;
import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dummyOrderUserService")
public class DummyOrderUserServiceImpl
implements DummyOrderUserService {
    private static final Logger log = LoggerFactory.getLogger(DummyOrderUserServiceImpl.class);
    @Autowired(required=false)
    private DummyOrderUserRepository dummyOrderUserRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<DummyOrderUserVo> findByConditions(Pageable pageable, DummyOrderUserPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new DummyOrderUserPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.dummyOrderUserRepository.findByConditions((Page<DummyOrderUserVo>)page, dto);
    }

    @Override
    public DummyOrderUserVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DummyOrderUser dummyOrderUser = this.dummyOrderUserRepository.findById(id);
        DummyOrderUserVo dummyOrderUserVo = (DummyOrderUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dummyOrderUser, DummyOrderUserVo.class, HashSet.class, LinkedList.class, new String[0]);
        return dummyOrderUserVo;
    }

    @Override
    @Transactional
    public DummyOrderUserVo create(DummyOrderUserVo dummyOrderUserVo) {
        this.createValidation(dummyOrderUserVo);
        DummyOrderUser dummyOrderUser = (DummyOrderUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dummyOrderUserVo, DummyOrderUser.class, HashSet.class, LinkedList.class, new String[0]));
        dummyOrderUser.setTenantCode(TenantUtils.getTenantCode());
        dummyOrderUser.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dummyOrderUser.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.dummyOrderUserRepository.saveOrUpdate((Object)dummyOrderUser);
        return dummyOrderUserVo;
    }

    @Override
    @Transactional
    public DummyOrderUserVo update(DummyOrderUserVo dummyOrderUserVo) {
        this.updateValidation(dummyOrderUserVo);
        String currentId = dummyOrderUserVo.getId();
        DummyOrderUser current = this.dummyOrderUserRepository.findById(currentId);
        current = (DummyOrderUser)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        current = (DummyOrderUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dummyOrderUserVo, DummyOrderUser.class, HashSet.class, LinkedList.class, new String[0]));
        this.dummyOrderUserRepository.saveOrUpdate((Object)current);
        return dummyOrderUserVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dummyOrderUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dummyOrderUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dummyOrderUserRepository.updateDelFlagByIds(ids);
    }

    @Override
    public List<DummyOrderUserVo> userInfoList(String orderCode) {
        List list = ((LambdaQueryChainWrapper)this.dummyOrderUserRepository.lambdaQuery().eq(DummyOrderUser::getOrderCode, (Object)orderCode)).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, DummyOrderUser.class, DummyOrderUserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public Page<DummyOrderApplyUserVo> findDummyOrderUserApplyByConditions(Pageable pageable, DummyOrderUserPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new DummyOrderUserPaginationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.dummyOrderUserRepository.findDummyOrderUserApplyByConditions((Page<DummyOrderApplyUserVo>)page, dto);
    }

    @Override
    public void batchSave(List<DummyOrderUserVo> list) {
        for (DummyOrderUserVo dummyOrderUserVo : list) {
            this.create(dummyOrderUserVo);
        }
    }

    private void createValidation(DummyOrderUserVo dummyOrderUserVo) {
        this.validation(dummyOrderUserVo);
    }

    private void updateValidation(DummyOrderUserVo dummyOrderUserVo) {
        this.validation(dummyOrderUserVo);
    }

    private void validation(DummyOrderUserVo dummyOrderUserVo) {
        Validate.notBlank((CharSequence)dummyOrderUserVo.getName(), (String)"\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dummyOrderUserVo.getPhone(), (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dummyOrderUserVo.getOrderCode(), (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

