/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.member.business.member.local.entity.HolidayIntegralRecord;
import com.biz.crm.member.business.member.local.helper.UserSearchHelper;
import com.biz.crm.member.business.member.local.repository.HolidayIntegralRecordRepository;
import com.biz.crm.member.business.member.local.repository.HolidayIntegralRepository;
import com.biz.crm.member.business.member.local.service.HolidayIntegralAction;
import com.biz.crm.member.business.member.sdk.enums.HolidayTypeEnum;
import com.biz.crm.member.business.member.sdk.vo.applet.AppletHolidayIntegralVo;
import com.biz.crm.member.business.member.sdk.vo.login.MemberUserDetails;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HolidayIntegralActionImpl
implements HolidayIntegralAction {
    @Autowired
    private HolidayIntegralRepository holidayIntegralRepository;
    @Autowired
    private HolidayIntegralRecordRepository holidayIntegralRecordRepository;
    @Autowired
    private UserSearchHelper userSearchHelper;

    @Override
    public BigDecimal getHolidayIntegralByDate(String memberCode, BigDecimal quantity, String type) {
        String nowDate = DateUtil.formatDate((Date)new Date());
        MemberUserDetails memberLogin = this.userSearchHelper.getMemberLogin();
        List<AppletHolidayIntegralVo> integralVos = this.holidayIntegralRepository.findByCurrentDate(memberCode, nowDate, type);
        if (CollUtil.isEmpty(integralVos)) {
            return null;
        }
        List integralRecords = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.holidayIntegralRecordRepository.lambdaQuery().eq(HolidayIntegralRecord::getMemberCode, (Object)memberCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
        Map<String, List<HolidayIntegralRecord>> recordMap = null;
        if (!CollUtil.isEmpty((Collection)integralRecords)) {
            recordMap = integralRecords.stream().collect(Collectors.groupingBy(HolidayIntegralRecord::getHolidayCode));
        }
        for (AppletHolidayIntegralVo integralVo : integralVos) {
            BigDecimal subtract;
            if (HolidayTypeEnum.BIRTHDAY.getCode().equals(integralVo.getType()) && !nowDate.equals(memberLogin.getMemberBirthday())) continue;
            Integer extraIntegralTop = integralVo.getExtraIntegralTop();
            BigDecimal multiple = integralVo.getMultiple();
            String holidayCode = integralVo.getHolidayCode();
            String channel = integralVo.getChannel();
            BigDecimal multiply = quantity.multiply(multiple);
            if (ObjectUtil.isNotNull(recordMap)) {
                return multiply;
            }
            List<HolidayIntegralRecord> records = recordMap.get(integralVo.getHolidayCode());
            if (CollUtil.isEmpty(records)) {
                return multiply;
            }
            BigDecimal reduce = records.stream().map(HolidayIntegralRecord::getExtraIntegralNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (reduce.add(subtract = multiply.subtract(quantity)).compareTo(new BigDecimal(extraIntegralTop)) > 0) continue;
            HolidayIntegralRecord record = new HolidayIntegralRecord();
            record.setHolidayCode(holidayCode);
            record.setIntegralNum(multiply);
            record.setExtraIntegralNum(subtract);
            record.setChannel(channel);
            record.setMemberPhone(memberLogin.getMemberPhone());
            record.setMemberCode(memberCode);
            this.holidayIntegralRecordRepository.saveOrUpdate((Object)record);
            return multiply;
        }
        return null;
    }
}

